/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.site.navigation.exception.InvalidSiteNavigationMenuItemOrderException;
import com.liferay.site.navigation.exception.InvalidSiteNavigationMenuItemTypeException;
import com.liferay.site.navigation.exception.SiteNavigationMenuItemNameException;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.base.SiteNavigationMenuItemLocalServiceBaseImpl;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import com.liferay.site.navigation.util.comparator.SiteNavigationMenuItemOrderComparator;
import java.util.Date;
import java.util.List;

public class SiteNavigationMenuItemLocalServiceImpl
extends SiteNavigationMenuItemLocalServiceBaseImpl {
    @ServiceReference(type=SiteNavigationMenuItemTypeRegistry.class)
    private SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;

    public SiteNavigationMenuItem addSiteNavigationMenuItem(long userId, long groupId, long siteNavigationMenuId, long parentSiteNavigationMenuItemId, String type, int order, String typeSettings, ServiceContext serviceContext) throws PortalException {
        SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType(type);
        if (siteNavigationMenuItemType == null) {
            throw new InvalidSiteNavigationMenuItemTypeException(type);
        }
        String name = siteNavigationMenuItemType.getName(typeSettings);
        this.validateName(name);
        User user = this.userLocalService.getUser(userId);
        long siteNavigationMenuItemId = this.counterLocalService.increment();
        SiteNavigationMenuItem siteNavigationMenuItem = this.siteNavigationMenuItemPersistence.create(siteNavigationMenuItemId);
        siteNavigationMenuItem.setUuid(serviceContext.getUuid());
        siteNavigationMenuItem.setGroupId(groupId);
        siteNavigationMenuItem.setCompanyId(user.getCompanyId());
        siteNavigationMenuItem.setUserId(userId);
        siteNavigationMenuItem.setUserName(user.getFullName());
        siteNavigationMenuItem.setSiteNavigationMenuId(siteNavigationMenuId);
        siteNavigationMenuItem.setParentSiteNavigationMenuItemId(parentSiteNavigationMenuItemId);
        siteNavigationMenuItem.setName(name);
        siteNavigationMenuItem.setType(type);
        siteNavigationMenuItem.setTypeSettings(typeSettings);
        siteNavigationMenuItem.setOrder(order);
        this.siteNavigationMenuItemPersistence.update((BaseModel)siteNavigationMenuItem);
        return siteNavigationMenuItem;
    }

    public SiteNavigationMenuItem addSiteNavigationMenuItem(long userId, long groupId, long siteNavigationMenuId, long parentSiteNavigationMenuItemId, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        int siteNavigationMenuItemCount = this.siteNavigationMenuItemPersistence.countByS_P(siteNavigationMenuId, parentSiteNavigationMenuItemId);
        return this.addSiteNavigationMenuItem(userId, groupId, siteNavigationMenuId, parentSiteNavigationMenuItemId, type, siteNavigationMenuItemCount, typeSettings, serviceContext);
    }

    @Override
    public SiteNavigationMenuItem deleteSiteNavigationMenuItem(long siteNavigationMenuItemId) throws PortalException {
        SiteNavigationMenuItem siteNavigationMenuItem = this.getSiteNavigationMenuItem(siteNavigationMenuItemId);
        List<SiteNavigationMenuItem> siteNavigationMenuItems = this.getSiteNavigationMenuItems(siteNavigationMenuItem.getSiteNavigationMenuId(), siteNavigationMenuItemId);
        if (!siteNavigationMenuItems.isEmpty()) {
            long parentSiteNavigationMenuItemId = siteNavigationMenuItem.getParentSiteNavigationMenuItemId();
            List<SiteNavigationMenuItem> siblingsSiteNavigationMenuItems = this.getSiteNavigationMenuItems(siteNavigationMenuItem.getSiteNavigationMenuId(), parentSiteNavigationMenuItemId);
            for (SiteNavigationMenuItem siblingSiteNavigationMenuItem : siblingsSiteNavigationMenuItems) {
                if (siblingSiteNavigationMenuItem.getOrder() <= siteNavigationMenuItem.getOrder()) continue;
                siblingSiteNavigationMenuItem.setOrder(siteNavigationMenuItems.size() + siteNavigationMenuItem.getOrder());
                this.siteNavigationMenuItemPersistence.update((BaseModel)siblingSiteNavigationMenuItem);
            }
        }
        for (int i = 0; i < siteNavigationMenuItems.size(); ++i) {
            SiteNavigationMenuItem childSiteNavigationMenuItem = siteNavigationMenuItems.get(i);
            childSiteNavigationMenuItem.setParentSiteNavigationMenuItemId(siteNavigationMenuItem.getParentSiteNavigationMenuItemId());
            childSiteNavigationMenuItem.setOrder(siteNavigationMenuItem.getOrder() + i);
            this.siteNavigationMenuItemPersistence.update((BaseModel)childSiteNavigationMenuItem);
        }
        return this.siteNavigationMenuItemLocalService.deleteSiteNavigationMenuItem(siteNavigationMenuItem);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public SiteNavigationMenuItem deleteSiteNavigationMenuItem(SiteNavigationMenuItem siteNavigationMenuItem) {
        return (SiteNavigationMenuItem)this.siteNavigationMenuItemPersistence.remove((BaseModel)siteNavigationMenuItem);
    }

    public void deleteSiteNavigationMenuItems(long siteNavigationMenuId) {
        this.siteNavigationMenuItemPersistence.removeBySiteNavigationMenuId(siteNavigationMenuId);
    }

    public void deleteSiteNavigationMenuItemsByGroupId(long groupId) {
        List siteNavigationMenus = this.siteNavigationMenuPersistence.findByGroupId(groupId);
        for (SiteNavigationMenu siteNavigationMenu : siteNavigationMenus) {
            this.siteNavigationMenuItemPersistence.removeBySiteNavigationMenuId(siteNavigationMenu.getSiteNavigationMenuId());
        }
    }

    public List<SiteNavigationMenuItem> getSiteNavigationMenuItems(long siteNavigationMenuId) {
        return this.siteNavigationMenuItemPersistence.findBySiteNavigationMenuId(siteNavigationMenuId);
    }

    public List<SiteNavigationMenuItem> getSiteNavigationMenuItems(long siteNavigationMenuId, long parentSiteNavigationMenuItemId) {
        return this.siteNavigationMenuItemPersistence.findByS_P(siteNavigationMenuId, parentSiteNavigationMenuItemId, -1, -1, (OrderByComparator)new SiteNavigationMenuItemOrderComparator());
    }

    public int getSiteNavigationMenuItemsCount(long siteNavigationMenuId) {
        return this.siteNavigationMenuItemPersistence.countBySiteNavigationMenuId(siteNavigationMenuId);
    }

    public SiteNavigationMenuItem updateSiteNavigationMenuItem(long siteNavigationMenuItemId, long parentSiteNavigationMenuItemId, int order) throws PortalException {
        SiteNavigationMenuItem siteNavigationMenuItem = this.siteNavigationMenuItemPersistence.fetchByPrimaryKey(siteNavigationMenuItemId);
        this.validate(siteNavigationMenuItem.getSiteNavigationMenuId(), siteNavigationMenuItemId, parentSiteNavigationMenuItemId);
        long oldParentSiteNavigationMenuItemId = siteNavigationMenuItem.getParentSiteNavigationMenuItemId();
        siteNavigationMenuItem.setParentSiteNavigationMenuItemId(parentSiteNavigationMenuItemId);
        siteNavigationMenuItem.setOrder(order);
        this.siteNavigationMenuItemPersistence.update((BaseModel)siteNavigationMenuItem);
        int newOrder = 0;
        List<SiteNavigationMenuItem> children = this.getSiteNavigationMenuItems(siteNavigationMenuItem.getSiteNavigationMenuId(), parentSiteNavigationMenuItemId);
        for (SiteNavigationMenuItem child : children) {
            if (newOrder == order) {
                ++newOrder;
            }
            if (child.getSiteNavigationMenuItemId() == siteNavigationMenuItemId) continue;
            child.setOrder(newOrder++);
            this.siteNavigationMenuItemPersistence.update((BaseModel)child);
        }
        if (parentSiteNavigationMenuItemId != oldParentSiteNavigationMenuItemId) {
            List<SiteNavigationMenuItem> oldChildren = this.getSiteNavigationMenuItems(siteNavigationMenuItem.getSiteNavigationMenuId(), oldParentSiteNavigationMenuItemId);
            for (SiteNavigationMenuItem oldChild : oldChildren) {
                if (oldChild.getOrder() <= order) continue;
                oldChild.setOrder(oldChild.getOrder() - 1);
                this.siteNavigationMenuItemPersistence.update((BaseModel)oldChild);
            }
        }
        return siteNavigationMenuItem;
    }

    public SiteNavigationMenuItem updateSiteNavigationMenuItem(long userId, long siteNavigationMenuItemId, long groupId, long siteNavigationMenuId, long parentSiteNavigationMenuItemId, String type, int order, String typeSettings) throws PortalException {
        SiteNavigationMenuItem siteNavigationMenuItem = this.siteNavigationMenuItemPersistence.findByPrimaryKey(siteNavigationMenuItemId);
        siteNavigationMenuItem.setGroupId(groupId);
        siteNavigationMenuItem.setUserId(userId);
        siteNavigationMenuItem.setSiteNavigationMenuId(siteNavigationMenuId);
        siteNavigationMenuItem.setParentSiteNavigationMenuItemId(parentSiteNavigationMenuItemId);
        siteNavigationMenuItem.setType(type);
        siteNavigationMenuItem.setTypeSettings(typeSettings);
        siteNavigationMenuItem.setOrder(order);
        return (SiteNavigationMenuItem)this.siteNavigationMenuItemPersistence.update((BaseModel)siteNavigationMenuItem);
    }

    public SiteNavigationMenuItem updateSiteNavigationMenuItem(long userId, long siteNavigationMenuItemId, String typeSettings, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        SiteNavigationMenuItem siteNavigationMenuItem = this.siteNavigationMenuItemPersistence.fetchByPrimaryKey(siteNavigationMenuItemId);
        SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType(siteNavigationMenuItem.getType());
        if (siteNavigationMenuItemType == null) {
            throw new InvalidSiteNavigationMenuItemTypeException(siteNavigationMenuItem.getType());
        }
        String name = siteNavigationMenuItemType.getName(typeSettings);
        this.validateName(name);
        siteNavigationMenuItem.setUserId(userId);
        siteNavigationMenuItem.setUserName(user.getFullName());
        siteNavigationMenuItem.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        siteNavigationMenuItem.setName(name);
        siteNavigationMenuItem.setTypeSettings(typeSettings);
        this.siteNavigationMenuItemPersistence.update((BaseModel)siteNavigationMenuItem);
        return siteNavigationMenuItem;
    }

    protected void validate(long siteNavigationMenuId, long siteNavigationMenuItemId, long parentSiteNavigationMenuItemId) throws PortalException {
        List<SiteNavigationMenuItem> siteNavigationMenuItems = this.getSiteNavigationMenuItems(siteNavigationMenuId, siteNavigationMenuItemId);
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            siteNavigationMenuItemId = siteNavigationMenuItem.getSiteNavigationMenuItemId();
            if (siteNavigationMenuItemId == parentSiteNavigationMenuItemId) {
                throw new InvalidSiteNavigationMenuItemOrderException();
            }
            this.validate(siteNavigationMenuId, siteNavigationMenuItemId, parentSiteNavigationMenuItemId);
        }
    }

    protected void validateName(String name) throws PortalException {
        if (name == null) {
            return;
        }
        int maxLength = ModelHintsUtil.getMaxLength((String)SiteNavigationMenuItem.class.getName(), (String)"name");
        if (name.length() > maxLength) {
            throw new SiteNavigationMenuItemNameException("Maximum length of name exceeded");
        }
    }
}

