/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.site.navigation.model.impl;

import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalServiceUtil;

/**
 * The extended model base implementation for the SiteNavigationMenuItem service. Represents a row in the &quot;SiteNavigationMenuItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SiteNavigationMenuItemImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SiteNavigationMenuItemImpl
 * @see SiteNavigationMenuItem
 * @generated
 */
public abstract class SiteNavigationMenuItemBaseImpl
	extends SiteNavigationMenuItemModelImpl implements SiteNavigationMenuItem {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a site navigation menu item model instance should use the <code>SiteNavigationMenuItem</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SiteNavigationMenuItemLocalServiceUtil.addSiteNavigationMenuItem(
				this);
		}
		else {
			SiteNavigationMenuItemLocalServiceUtil.updateSiteNavigationMenuItem(
				this);
		}
	}

}