/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.service.impl;

import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.site.navigation.exception.DuplicateSiteNavigationMenuException;
import com.liferay.site.navigation.exception.RequiredPrimarySiteNavigationMenuException;
import com.liferay.site.navigation.exception.SiteNavigationMenuNameException;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.base.SiteNavigationMenuLocalServiceBaseImpl;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import java.util.Date;
import java.util.List;

public class SiteNavigationMenuLocalServiceImpl
extends SiteNavigationMenuLocalServiceBaseImpl {
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;
    @ServiceReference(type=SiteNavigationMenuItemTypeRegistry.class)
    private SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;

    public SiteNavigationMenu addDefaultSiteNavigationMenu(long userId, long groupId, ServiceContext serviceContext) throws PortalException {
        Group group = this.groupLocalService.fetchGroup(groupId);
        SiteNavigationMenu publicSiteNavigationMenu = this.fetchSiteNavigationMenu(groupId, 1);
        if (publicSiteNavigationMenu != null && !this.layoutLocalService.hasLayouts(group, false)) {
            return publicSiteNavigationMenu;
        }
        publicSiteNavigationMenu = this.addSiteNavigationMenu(userId, groupId, "Default", 1, true, serviceContext);
        this._addSiteNavigationMenuItems(publicSiteNavigationMenu, 0L, false, 0L, serviceContext);
        return publicSiteNavigationMenu;
    }

    public SiteNavigationMenu addSiteNavigationMenu(long userId, long groupId, String name, int type, boolean auto, ServiceContext serviceContext) throws PortalException {
        this.validate(groupId, name);
        User user = this.userLocalService.getUser(userId);
        long siteNavigationMenuId = this.counterLocalService.increment();
        SiteNavigationMenu siteNavigationMenu = this.siteNavigationMenuPersistence.create(siteNavigationMenuId);
        siteNavigationMenu.setUuid(serviceContext.getUuid());
        siteNavigationMenu.setGroupId(groupId);
        siteNavigationMenu.setCompanyId(user.getCompanyId());
        siteNavigationMenu.setUserId(userId);
        siteNavigationMenu.setUserName(user.getFullName());
        siteNavigationMenu.setName(name);
        siteNavigationMenu.setType(type);
        siteNavigationMenu.setAuto(auto);
        this.siteNavigationMenuPersistence.update((BaseModel)siteNavigationMenu);
        this.resourceLocalService.addResources(siteNavigationMenu.getCompanyId(), siteNavigationMenu.getGroupId(), siteNavigationMenu.getUserId(), SiteNavigationMenu.class.getName(), siteNavigationMenu.getSiteNavigationMenuId(), false, true, true);
        this._updateOldSiteNavigationMenuType(siteNavigationMenu, type);
        return siteNavigationMenu;
    }

    public SiteNavigationMenu addSiteNavigationMenu(long userId, long groupId, String name, int type, ServiceContext serviceContext) throws PortalException {
        return this.addSiteNavigationMenu(userId, groupId, name, type, false, serviceContext);
    }

    public SiteNavigationMenu addSiteNavigationMenu(long userId, long groupId, String name, ServiceContext serviceContext) throws PortalException {
        int type = 0;
        int siteNavigationMenusCount = this.getSiteNavigationMenusCount(serviceContext.getScopeGroupId());
        if (siteNavigationMenusCount <= 0) {
            type = 1;
        }
        return this.addSiteNavigationMenu(userId, groupId, name, type, serviceContext);
    }

    @Override
    public SiteNavigationMenu deleteSiteNavigationMenu(long siteNavigationMenuId) throws PortalException {
        SiteNavigationMenu siteNavigationMenu = this.getSiteNavigationMenu(siteNavigationMenuId);
        return this.deleteSiteNavigationMenu(siteNavigationMenu);
    }

    @Override
    public SiteNavigationMenu deleteSiteNavigationMenu(SiteNavigationMenu siteNavigationMenu) throws PortalException {
        SiteNavigationMenu primarySiteNavigationMenu = this.fetchPrimarySiteNavigationMenu(siteNavigationMenu.getGroupId());
        int siteNavigationMenuCount = this.getSiteNavigationMenusCount(siteNavigationMenu.getGroupId());
        if (primarySiteNavigationMenu != null && siteNavigationMenuCount > 1 && primarySiteNavigationMenu.getSiteNavigationMenuId() == siteNavigationMenu.getSiteNavigationMenuId()) {
            throw new RequiredPrimarySiteNavigationMenuException();
        }
        this.siteNavigationMenuPersistence.remove(siteNavigationMenu.getSiteNavigationMenuId());
        this.resourceLocalService.deleteResource(siteNavigationMenu.getCompanyId(), SiteNavigationMenuItem.class.getName(), 4, siteNavigationMenu.getSiteNavigationMenuId());
        List siteNavigationMenuItems = this.siteNavigationMenuItemLocalService.getSiteNavigationMenuItems(siteNavigationMenu.getSiteNavigationMenuId());
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            this.siteNavigationMenuItemLocalService.deleteSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId());
        }
        return siteNavigationMenu;
    }

    public void deleteSiteNavigationMenus(long groupId) {
        this.siteNavigationMenuPersistence.removeByGroupId(groupId);
    }

    public SiteNavigationMenu fetchPrimarySiteNavigationMenu(long groupId) {
        return this.fetchSiteNavigationMenu(groupId, 1);
    }

    public SiteNavigationMenu fetchSiteNavigationMenu(long groupId, int type) {
        List siteNavigationMenus = this.siteNavigationMenuPersistence.findByG_T(groupId, type, 0, 1);
        if (siteNavigationMenus.isEmpty()) {
            return null;
        }
        return (SiteNavigationMenu)siteNavigationMenus.get(0);
    }

    public List<SiteNavigationMenu> getAutoSiteNavigationMenus(long groupId) {
        return this.siteNavigationMenuPersistence.findByG_A(groupId, true);
    }

    public List<SiteNavigationMenu> getSiteNavigationMenus(long groupId) {
        return this.siteNavigationMenuPersistence.findByGroupId(groupId);
    }

    public List<SiteNavigationMenu> getSiteNavigationMenus(long groupId, int start, int end, OrderByComparator orderByComparator) {
        return this.siteNavigationMenuPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<SiteNavigationMenu> getSiteNavigationMenus(long groupId, String keywords, int start, int end, OrderByComparator orderByComparator) {
        return this.siteNavigationMenuPersistence.findByG_LikeN(groupId, this._customSQL.keywords(keywords, WildcardMode.SURROUND)[0], start, end, orderByComparator);
    }

    public int getSiteNavigationMenusCount(long groupId) {
        return this.siteNavigationMenuPersistence.countByGroupId(groupId);
    }

    public int getSiteNavigationMenusCount(long groupId, String keywords) {
        return this.siteNavigationMenuPersistence.countByG_LikeN(groupId, this._customSQL.keywords(keywords, WildcardMode.SURROUND)[0]);
    }

    public SiteNavigationMenu updateSiteNavigationMenu(long userId, long siteNavigationMenuId, int type, boolean auto, ServiceContext serviceContext) throws PortalException {
        SiteNavigationMenu siteNavigationMenu = this.getSiteNavigationMenu(siteNavigationMenuId);
        this._updateOldSiteNavigationMenuType(siteNavigationMenu, type);
        User user = this.userLocalService.getUser(userId);
        siteNavigationMenu.setUserId(userId);
        siteNavigationMenu.setUserName(user.getFullName());
        siteNavigationMenu.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        siteNavigationMenu.setType(type);
        siteNavigationMenu.setAuto(auto);
        return (SiteNavigationMenu)this.siteNavigationMenuPersistence.update((BaseModel)siteNavigationMenu);
    }

    public SiteNavigationMenu updateSiteNavigationMenu(long userId, long siteNavigationMenuId, long groupId, String name, int type, boolean auto) throws PortalException {
        SiteNavigationMenu siteNavigationMenu = this.siteNavigationMenuPersistence.findByPrimaryKey(siteNavigationMenuId);
        siteNavigationMenu.setGroupId(groupId);
        siteNavigationMenu.setUserId(userId);
        siteNavigationMenu.setName(name);
        siteNavigationMenu.setType(type);
        siteNavigationMenu.setAuto(auto);
        return (SiteNavigationMenu)this.siteNavigationMenuPersistence.update((BaseModel)siteNavigationMenu);
    }

    public SiteNavigationMenu updateSiteNavigationMenu(long userId, long siteNavigationMenuId, String name, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        SiteNavigationMenu siteNavigationMenu = this.getSiteNavigationMenu(siteNavigationMenuId);
        this.validate(siteNavigationMenu.getGroupId(), name);
        siteNavigationMenu.setUserId(userId);
        siteNavigationMenu.setUserName(user.getFullName());
        siteNavigationMenu.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        siteNavigationMenu.setName(name);
        return (SiteNavigationMenu)this.siteNavigationMenuPersistence.update((BaseModel)siteNavigationMenu);
    }

    protected void validate(long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new SiteNavigationMenuNameException();
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)SiteNavigationMenu.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new SiteNavigationMenuNameException("Maximum length of name exceeded");
        }
        SiteNavigationMenu siteNavigationMenu = this.siteNavigationMenuPersistence.fetchByG_N(groupId, name);
        if (siteNavigationMenu != null) {
            throw new DuplicateSiteNavigationMenuException(name);
        }
    }

    private void _addSiteNavigationMenuItems(SiteNavigationMenu siteNavigationMenu, long parentSiteNavigationMenuId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType("layout");
        if (siteNavigationMenuItemType == null) {
            return;
        }
        List layouts = this.layoutLocalService.getLayouts(siteNavigationMenu.getGroupId(), privateLayout, layoutId);
        for (Layout layout : layouts) {
            if (layout.isHidden()) continue;
            String typeSettings = siteNavigationMenuItemType.getTypeSettingsFromLayout(layout);
            SiteNavigationMenuItem siteNavigationMenuItem = this.siteNavigationMenuItemLocalService.addSiteNavigationMenuItem(siteNavigationMenu.getUserId(), siteNavigationMenu.getGroupId(), siteNavigationMenu.getSiteNavigationMenuId(), parentSiteNavigationMenuId, siteNavigationMenuItemType.getType(), typeSettings, serviceContext);
            this._addSiteNavigationMenuItems(siteNavigationMenu, siteNavigationMenuItem.getSiteNavigationMenuItemId(), privateLayout, layout.getLayoutId(), serviceContext);
        }
    }

    private void _updateOldSiteNavigationMenuType(SiteNavigationMenu siteNavigationMenu, int type) throws PortalException {
        SiteNavigationMenu primarySiteNavigationMenu = this.fetchPrimarySiteNavigationMenu(siteNavigationMenu.getGroupId());
        if (primarySiteNavigationMenu != null && primarySiteNavigationMenu.getSiteNavigationMenuId() == siteNavigationMenu.getSiteNavigationMenuId() && type != 1) {
            throw new RequiredPrimarySiteNavigationMenuException();
        }
        if (type == 0) {
            return;
        }
        List siteNavigationMenus = this.siteNavigationMenuPersistence.findByG_T(siteNavigationMenu.getGroupId(), type, 0, 1);
        if (siteNavigationMenus.isEmpty()) {
            return;
        }
        SiteNavigationMenu actualTypeSiteNavigationMenu = (SiteNavigationMenu)siteNavigationMenus.get(0);
        if (actualTypeSiteNavigationMenu.getType() == type && actualTypeSiteNavigationMenu.getSiteNavigationMenuId() == siteNavigationMenu.getSiteNavigationMenuId()) {
            return;
        }
        actualTypeSiteNavigationMenu.setType(0);
        this.siteNavigationMenuPersistence.update((BaseModel)actualTypeSiteNavigationMenu);
    }
}

