/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor;

import com.liferay.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor.util.ObjectEntryUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dispatch.task.executor.feature.flag=LPS-166126", "dispatch.task.executor.name=testray-testflow", "dispatch.task.executor.overlapping=false", "dispatch.task.executor.type=testray-testflow"}, service={DispatchTaskExecutor.class})
public class SiteInitializerTestrayTestFlowDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(SiteInitializerTestrayTestFlowDispatchTaskExecutor.class);
    private DefaultDTOConverterContext _defaultDTOConverterContext;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference(target="(object.entry.manager.storage.type=default)")
    private ObjectEntryManager _objectEntryManager;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        UnicodeProperties unicodeProperties = dispatchTrigger.getDispatchTaskSettingsUnicodeProperties();
        if (Validator.isNull((String)unicodeProperties.getProperty("testrayBuildId")) || Validator.isNull((String)unicodeProperties.getProperty("testrayCaseTypeIds")) || Validator.isNull((String)unicodeProperties.getProperty("testrayTaskId"))) {
            _log.error((Object)"The required properties are not set");
            return;
        }
        User user = this._userLocalService.getUser(dispatchTrigger.getUserId());
        this._defaultDTOConverterContext = new DefaultDTOConverterContext(false, null, null, null, null, LocaleUtil.getSiteDefault(), null, user);
        PermissionChecker originalPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
        String originalName = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        try {
            ObjectEntryUtil.loadObjectDefinitions(dispatchTrigger.getCompanyId(), this._objectDefinitionLocalService);
            this._updateTestrayTaskStatus(unicodeProperties, "PROCESSING");
            this._process(dispatchTrigger.getCompanyId(), unicodeProperties);
            this._updateTestrayTaskStatus(unicodeProperties, "INANALYSIS");
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)originalPermissionChecker);
            PrincipalThreadLocal.setName((String)originalName);
        }
    }

    public String getName() {
        return "testray-testflow";
    }

    public boolean isClusterModeSingle() {
        return true;
    }

    private List<Facet.FacetValue> _getFacetValues(long companyId, long testrayBuildId) throws Exception {
        Page<ObjectEntry> page = ObjectEntryUtil.getObjectEntriesPage(new Aggregation(){
            {
                this.setAggregationTerms(HashMapBuilder.put((Object)"errors", (Object)"errors").build());
            }
        }, companyId, this._defaultDTOConverterContext, "buildId eq '" + testrayBuildId + "'", "CaseResult", this._objectEntryManager, null);
        List facets = page.getFacets();
        Facet facet = (Facet)facets.get(0);
        return facet.getFacetValues();
    }

    private String _getFilterString(UnicodeProperties unicodeProperties) {
        StringBundler sb = new StringBundler();
        String[] testrayCaseTypeIds = StringUtil.split((String)unicodeProperties.getProperty("testrayCaseTypeIds"));
        for (int i = 0; i <= testrayCaseTypeIds.length - 1; ++i) {
            sb.append("caseTypeId eq '");
            sb.append(testrayCaseTypeIds[i]);
            sb.append("'");
            sb.append(" or ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private String _getTestrayIssueNames(long companyId, ObjectEntry testrayCaseResultObjectEntry) throws Exception {
        List<ObjectEntry> testrayCaseResultsIssuesObjectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, "caseResultId eq '" + testrayCaseResultObjectEntry.getId() + "'", "CaseResultsIssues", this._objectEntryManager, null);
        if (testrayCaseResultsIssuesObjectEntries.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (ObjectEntry testrayCaseResultsIssuesObjectEntry : testrayCaseResultsIssuesObjectEntries) {
            long testrayIssueId = (Long)ObjectEntryUtil.getProperty("r_issueToCaseResultsIssues_c_issueId", testrayCaseResultsIssuesObjectEntry);
            ObjectEntry testrayIssueObjectEntry = ObjectEntryUtil.getObjectEntry(this._defaultDTOConverterContext, "Issue", testrayIssueId, this._objectEntryManager);
            sb.append(StringUtil.removeSubstring((String)((String)ObjectEntryUtil.getProperty("name", testrayIssueObjectEntry)), (String)"-"));
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private int _getTestraySubtaskScore(List<ObjectEntry> objectEntries) throws Exception {
        int score = 0;
        for (ObjectEntry objectEntry : objectEntries) {
            Long testrayCaseId = (Long)ObjectEntryUtil.getProperty("r_caseToCaseResult_c_caseId", objectEntry);
            ObjectEntry testrayCaseObjectEntry = ObjectEntryUtil.getObjectEntry(this._defaultDTOConverterContext, "Case", testrayCaseId, this._objectEntryManager);
            score += ((Integer)ObjectEntryUtil.getProperty("priority", testrayCaseObjectEntry)).intValue();
        }
        return score;
    }

    private void _process(long companyId, UnicodeProperties unicodeProperties) throws Exception {
        long testrayBuildId = GetterUtil.getLong((String)unicodeProperties.getProperty("testrayBuildId"));
        List testrayCaseObjectEntriesIds = TransformUtil.transform(ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, this._getFilterString(unicodeProperties), "Case", this._objectEntryManager, null), ObjectEntry::getId);
        ArrayList testrayCaseResultObjectEntriesList = new ArrayList();
        for (Facet.FacetValue facetValue : this._getFacetValues(companyId, testrayBuildId)) {
            if (Objects.equals(facetValue.getTerm(), "null")) continue;
            HashMap<String, ArrayList<ObjectEntry>> map = new HashMap<String, ArrayList<ObjectEntry>>();
            for (ObjectEntry testrayCaseResultObjectEntry : ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, StringBundler.concat((Object[])new Object[]{"buildId eq '", testrayBuildId, "' and errors eq '", StringUtil.removeChar((String)StringUtil.replace((String)facetValue.getTerm(), (char)'\'', (String)"''"), (char)'\\'), "'"}), "CaseResult", this._objectEntryManager, null)) {
                if (!testrayCaseObjectEntriesIds.contains((Long)ObjectEntryUtil.getProperty("r_caseToCaseResult_c_caseId", testrayCaseResultObjectEntry))) continue;
                String testrayIssueNames = this._getTestrayIssueNames(companyId, testrayCaseResultObjectEntry);
                ArrayList<ObjectEntry> testrayCaseResultObjectEntries = (ArrayList<ObjectEntry>)map.get(testrayIssueNames);
                if (testrayCaseResultObjectEntries == null) {
                    testrayCaseResultObjectEntries = new ArrayList<ObjectEntry>();
                    map.put(testrayIssueNames, testrayCaseResultObjectEntries);
                }
                testrayCaseResultObjectEntries.add(testrayCaseResultObjectEntry);
            }
            testrayCaseResultObjectEntriesList.addAll(map.values());
        }
        ListUtil.sort(testrayCaseResultObjectEntriesList, (Comparator)new Comparator<List<ObjectEntry>>(){

            @Override
            public int compare(List<ObjectEntry> testrayCaseResultObjectEntries1, List<ObjectEntry> testrayCaseResultObjectEntries2) {
                int testraySubtaskScore1 = 0;
                int testraySubtaskScore2 = 0;
                try {
                    testraySubtaskScore1 = SiteInitializerTestrayTestFlowDispatchTaskExecutor.this._getTestraySubtaskScore(testrayCaseResultObjectEntries1);
                    testraySubtaskScore2 = SiteInitializerTestrayTestFlowDispatchTaskExecutor.this._getTestraySubtaskScore(testrayCaseResultObjectEntries2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (testraySubtaskScore1 > testraySubtaskScore2) {
                    return -1;
                }
                if (testraySubtaskScore1 < testraySubtaskScore2) {
                    return 1;
                }
                return 0;
            }
        });
        long testrayTaskId = GetterUtil.getLong((String)unicodeProperties.getProperty("testrayTaskId"));
        for (List testrayCaseResultObjectEntries : testrayCaseResultObjectEntriesList) {
            long testraySubtaskNumber = ObjectEntryUtil.increment(companyId, this._defaultDTOConverterContext, "taskId eq '" + testrayTaskId + "'", "number", "Subtask", this._objectEntryManager, new Sort[]{new Sort("nestedFieldArray.value_long#number", true)});
            ObjectEntry firstTestrayCaseResultObjectEntry = (ObjectEntry)testrayCaseResultObjectEntries.get(0);
            Map properties = firstTestrayCaseResultObjectEntry.getProperties();
            ObjectEntry testraySubtaskObjectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Subtask", this._objectEntryManager, HashMapBuilder.put((Object)"dueStatus", (Object)"OPEN").put((Object)"errors", properties.get("errors")).put((Object)"name", (Object)("ST-" + testraySubtaskNumber)).put((Object)"number", (Object)testraySubtaskNumber).put((Object)"r_taskToSubtasks_c_taskId", (Object)testrayTaskId).put((Object)"score", (Object)this._getTestraySubtaskScore(testrayCaseResultObjectEntries)).build());
            for (ObjectEntry testrayCaseResultObjectEntry : testrayCaseResultObjectEntries) {
                ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "SubtasksCasesResults", this._objectEntryManager, HashMapBuilder.put((Object)"r_caseResultToSubtasksCasesResults_c_caseResultId", (Object)testrayCaseResultObjectEntry.getId()).put((Object)"r_subtaskToSubtasksCasesResults_c_subtaskId", (Object)String.valueOf(testraySubtaskObjectEntry.getId())).build());
            }
        }
    }

    private void _updateTestrayTaskStatus(UnicodeProperties unicodeProperties, String testrayTaskStatus) throws Exception {
        long testrayTaskId = GetterUtil.getLong((String)unicodeProperties.getProperty("testrayTaskId"));
        ObjectEntry objectEntry = ObjectEntryUtil.getObjectEntry(this._defaultDTOConverterContext, "Task", testrayTaskId, this._objectEntryManager);
        Map properties = objectEntry.getProperties();
        properties.replace("dueStatus", testrayTaskStatus);
        objectEntry.setProperties(() -> properties);
        ObjectEntryUtil.updateObjectEntry(this._defaultDTOConverterContext, "Task", objectEntry, testrayTaskId, this._objectEntryManager);
    }
}

