/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.liferay.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor.util.ObjectEntryUtil;
import com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor.util.TestrayUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(property={"dispatch.task.executor.feature.flag=LPS-163118", "dispatch.task.executor.name=testray-import-results", "dispatch.task.executor.overlapping=false", "dispatch.task.executor.type=testray-import-results"}, service={DispatchTaskExecutor.class})
public class SiteInitializerTestrayImportResultsDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(SiteInitializerTestrayImportResultsDispatchTaskExecutor.class);
    private DefaultDTOConverterContext _defaultDTOConverterContext;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final Map<String, Long> _objectEntryIds = new HashMap<String, Long>();
    @Reference(target="(object.entry.manager.storage.type=default)")
    private ObjectEntryManager _objectEntryManager;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        UnicodeProperties unicodeProperties = dispatchTrigger.getDispatchTaskSettingsUnicodeProperties();
        if (Validator.isNull((String)unicodeProperties.getProperty("s3APIKey")) || Validator.isNull((String)unicodeProperties.getProperty("s3BucketName")) || Validator.isNull((String)unicodeProperties.getProperty("s3ErroredFolderName")) || Validator.isNull((String)unicodeProperties.getProperty("s3InboxFolderName")) || Validator.isNull((String)unicodeProperties.getProperty("s3ProcessedFolderName"))) {
            _log.error((Object)"The required properties are not set");
            return;
        }
        User user = this._userLocalService.getUser(dispatchTrigger.getUserId());
        this._defaultDTOConverterContext = new DefaultDTOConverterContext(false, null, null, null, null, LocaleUtil.getSiteDefault(), null, user);
        PermissionChecker originalPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
        String originalName = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        try {
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._load(dispatchTrigger.getCompanyId())));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._uploadToTestray(dispatchTrigger.getCompanyId(), unicodeProperties)));
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)originalPermissionChecker);
            PrincipalThreadLocal.setName((String)originalName);
        }
    }

    public String getName() {
        return "testray-import-results";
    }

    public boolean isClusterModeSingle() {
        return true;
    }

    private JSONArray _addTestrayAttachments(Node testcaseNode) throws Exception {
        JSONArray jsonArray = null;
        Element testcaseElement = (Element)testcaseNode;
        NodeList attachmentsNodeList = testcaseElement.getElementsByTagName("attachments");
        for (int i = 0; i < attachmentsNodeList.getLength(); ++i) {
            Node attachmentsNode = attachmentsNodeList.item(i);
            if (attachmentsNode.getNodeType() != 1) continue;
            Element attachmentsElement = (Element)attachmentsNode;
            NodeList fileNodeList = attachmentsElement.getElementsByTagName("file");
            for (int j = 0; j < fileNodeList.getLength(); ++j) {
                Node fileNode = fileNodeList.item(j);
                if (fileNode.getNodeType() != 1) continue;
                Element fileElement = (Element)fileNode;
                jsonArray = JSONUtil.put((Object)JSONUtil.put((String)"name", (Object)fileElement.getAttribute("name")).put("url", fileElement.getAttribute("url")).put("value", fileElement.getAttribute("value")));
            }
        }
        return jsonArray;
    }

    private void _addTestrayCase(long companyId, Node testcaseNode, long testrayBuildId, String testrayBuildTime, Map<String, Object> testrayCasePropertiesMap, long testrayProjectId, long testrayRunId) throws Exception {
        ObjectEntry objectEntry;
        String testrayCaseName = (String)testrayCasePropertiesMap.get("testray.testcase.name");
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Case#", testrayCaseName, "#ProjectId#", testrayProjectId});
        long testrayCaseId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayCaseName, "'"}), "Case", objectEntryIdsKey);
        long testrayTeamId = this._getTestrayTeamId(companyId, testrayProjectId, (String)testrayCasePropertiesMap.get("testray.team.name"));
        long testrayComponentId = this._getTestrayComponentId(companyId, (String)testrayCasePropertiesMap.get("testray.main.component.name"), testrayProjectId, testrayTeamId);
        if (testrayCaseId == 0L) {
            objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Case", this._objectEntryManager, HashMapBuilder.put((Object)"description", (Object)testrayCasePropertiesMap.get("testray.testcase.description")).put((Object)"name", (Object)((String)testrayCasePropertiesMap.get("testray.testcase.name"))).put((Object)"number", (Object)ObjectEntryUtil.increment(companyId, this._defaultDTOConverterContext, "projectId eq '" + testrayProjectId + "'", "number", "Case", this._objectEntryManager, new Sort[]{new Sort("nestedFieldArray.value_long#number", true)})).put((Object)"priority", testrayCasePropertiesMap.get("testray.testcase.priority")).put((Object)"r_caseTypeToCases_c_caseTypeId", (Object)this._getTestrayCaseTypeId(companyId, (String)testrayCasePropertiesMap.get("testray.case.type.name"))).put((Object)"r_componentToCases_c_componentId", (Object)testrayComponentId).put((Object)"r_projectToCases_c_projectId", (Object)testrayProjectId).build());
            testrayCaseId = objectEntry.getId();
            this._objectEntryIds.put(objectEntryIdsKey, testrayCaseId);
        }
        if ((objectEntry = (ObjectEntry)ObjectEntryUtil.getObjectEntriesPage(null, companyId, this._defaultDTOConverterContext, StringBundler.concat((Object[])new Object[]{"buildId eq '", testrayBuildId, "' and caseId eq '", testrayCaseId, "'"}), "BuildsCases", this._objectEntryManager, null).fetchFirstItem()) == null) {
            ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "BuildsCases", this._objectEntryManager, HashMapBuilder.put((Object)"r_buildToBuildsCases_c_buildId", (Object)testrayBuildId).put((Object)"r_caseToBuildsCases_c_caseId", (Object)testrayCaseId).build());
        }
        long testrayCaseResultId = this._getTestrayCaseResultId(testcaseNode, testrayBuildId, testrayBuildTime, testrayCaseId, testrayCasePropertiesMap, testrayComponentId, testrayRunId);
        TestrayUtil.addTestrayCaseResultIssue(companyId, this._defaultDTOConverterContext, this._objectEntryManager, testrayCaseResultId, (String)testrayCasePropertiesMap.get("testray.case.defect"));
        TestrayUtil.addTestrayCaseResultIssue(companyId, this._defaultDTOConverterContext, this._objectEntryManager, testrayCaseResultId, (String)testrayCasePropertiesMap.get("testray.case.issue"));
    }

    private void _addTestrayCases(long companyId, Element element, long testrayBuildId, String testrayBuildTime, long testrayProjectId, long testrayRunId) throws Exception {
        NodeList testCaseNodeList = element.getElementsByTagName("testcase");
        for (int i = 0; i < testCaseNodeList.getLength(); ++i) {
            Node testcaseNode = testCaseNodeList.item(i);
            Map<String, Object> testrayCasePropertiesMap = this._getTestrayCaseProperties((Element)testcaseNode);
            this._addTestrayCase(companyId, testcaseNode, testrayBuildId, testrayBuildTime, testrayCasePropertiesMap, testrayProjectId, testrayRunId);
        }
    }

    private void _addTestrayFactor(long testrayFactorCategoryId, String testrayFactorCategoryName, long testrayFactorOptionId, String testrayFactorOptionName, long testrayRunId) throws Exception {
        ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Factor", this._objectEntryManager, HashMapBuilder.put((Object)"r_factorCategoryToFactors_c_factorCategoryId", (Object)testrayFactorCategoryId).put((Object)"r_factorOptionToFactors_c_factorOptionId", (Object)testrayFactorOptionId).put((Object)"r_runToFactors_c_runId", (Object)testrayRunId).put((Object)"testrayFactorCategoryName", (Object)testrayFactorCategoryName).put((Object)"testrayFactorOptionName", (Object)testrayFactorOptionName).build());
    }

    private ObjectEntry _fetchLatestTestrayRunObjectEntry(long companyId, String environmentHash, long testrayRoutineId, long testrayRunId) throws Exception {
        List<ObjectEntry> testrayBuildsObjectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, "routineId eq '" + testrayRoutineId + "'", "Build", this._objectEntryManager, null);
        List<ObjectEntry> testrayRunsObjectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, StringBundler.concat((Object[])new Object[]{"environmentHash eq '", environmentHash, "' and id ne '", testrayRunId, "'"}), "Run", this._objectEntryManager, new Sort[]{new Sort("createDate", 3, true)});
        for (ObjectEntry testrayRunObjectEntry : testrayRunsObjectEntries) {
            for (ObjectEntry testrayBuildObjectEntry : testrayBuildsObjectEntries) {
                if (!Objects.equals(testrayBuildObjectEntry.getId(), ObjectEntryUtil.getProperty("r_buildToRuns_c_buildId", testrayRunObjectEntry))) continue;
                return testrayRunObjectEntry;
            }
        }
        return null;
    }

    private String _getAttributeValue(String attributeName, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node attributeNode = namedNodeMap.getNamedItem(attributeName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getTextContent();
    }

    private long _getObjectEntryId(long companyId, String filterString, String objectDefinitionShortName, String objectEntryIdsKey) throws Exception {
        Long objectEntryId = this._objectEntryIds.get(objectEntryIdsKey);
        if (objectEntryId != null) {
            return objectEntryId;
        }
        com.liferay.portal.vulcan.pagination.Page<ObjectEntry> page = ObjectEntryUtil.getObjectEntriesPage(null, companyId, this._defaultDTOConverterContext, filterString, objectDefinitionShortName, this._objectEntryManager, null);
        ObjectEntry objectEntry = (ObjectEntry)page.fetchFirstItem();
        if (objectEntry == null) {
            return 0L;
        }
        return objectEntry.getId();
    }

    private Map<String, String> _getPropertiesMap(Element element) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList propertiesNodeList = element.getElementsByTagName("properties");
        Node propertiesNode = propertiesNodeList.item(0);
        Element propertiesElement = (Element)propertiesNode;
        NodeList propertyNodeList = propertiesElement.getElementsByTagName("property");
        for (int i = 0; i < propertyNodeList.getLength(); ++i) {
            Node propertyNode = propertyNodeList.item(i);
            if (!propertyNode.hasAttributes()) continue;
            map.put(this._getAttributeValue("name", propertyNode), this._getAttributeValue("value", propertyNode));
        }
        return map;
    }

    private String _getTestrayBuildDescription(Map<String, String> propertiesMap) {
        StringBundler sb = new StringBundler(15);
        if (propertiesMap.get("liferay.portal.bundle") != null) {
            sb.append("Bundle: ");
            sb.append(propertiesMap.get("liferay.portal.bundle"));
            sb.append(";");
            sb.append("\n");
        }
        if (propertiesMap.get("liferay.plugins.git.id") != null) {
            sb.append("Plugins hash: ");
            sb.append(propertiesMap.get("liferay.plugins.git.id"));
            sb.append(";");
            sb.append("\n");
        }
        if (propertiesMap.get("liferay.portal.branch") != null) {
            sb.append("Portal branch: ");
            sb.append(propertiesMap.get("liferay.portal.branch"));
            sb.append(";");
            sb.append("\n");
        }
        if (propertiesMap.get("liferay.portal.git.id") != null) {
            sb.append("Portal hash: ");
            sb.append(propertiesMap.get("liferay.portal.git.id"));
            sb.append(";");
        }
        return sb.toString();
    }

    private long _getTestrayBuildId(long companyId, Map<String, String> propertiesMap, String testrayBuildName, long testrayProjectId, long testrayRoutineId) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Build#", testrayBuildName, "#ProjectId#", testrayProjectId});
        long testrayBuildId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayBuildName, "'"}), "Build", objectEntryIdsKey);
        if (testrayBuildId != 0L) {
            return testrayBuildId;
        }
        long testrayProductVersionId = this._getTestrayProductVersionId(companyId, propertiesMap.get("testray.product.version"), testrayProjectId);
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Build", this._objectEntryManager, HashMapBuilder.put((Object)"description", (Object)this._getTestrayBuildDescription(propertiesMap)).put((Object)"dueDate", (Object)propertiesMap.get("testray.build.time")).put((Object)"dueStatus", (Object)"ACTIVATED").put((Object)"gitHash", (Object)propertiesMap.get("git.id")).put((Object)"githubCompareURLs", (Object)propertiesMap.get("liferay.compare.urls")).put((Object)"name", (Object)testrayBuildName).put((Object)"r_productVersionToBuilds_c_productVersionId", (Object)testrayProductVersionId).put((Object)"r_projectToBuilds_c_projectId", (Object)testrayProjectId).put((Object)"r_routineToBuilds_c_routineId", (Object)testrayRoutineId).build());
        testrayBuildId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayBuildId);
        return testrayBuildId;
    }

    private Map<String, Object> _getTestrayCaseProperties(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NodeList propertiesNodeList = element.getElementsByTagName("properties");
        Node propertiesNode = propertiesNodeList.item(0);
        Element propertiesElement = (Element)propertiesNode;
        NodeList propertyNodeList = propertiesElement.getElementsByTagName("property");
        for (int i = 0; i < propertyNodeList.getLength(); ++i) {
            Node propertyNode = propertyNodeList.item(i);
            if (!propertyNode.hasAttributes()) continue;
            map.put(this._getAttributeValue("name", propertyNode), this._getAttributeValue("value", propertyNode));
        }
        return map;
    }

    private long _getTestrayCaseResultId(Node testcaseNode, long testrayBuildId, String testrayBuildTime, long testrayCaseId, Map<String, Object> testrayCasePropertiesMap, long testrayComponentId, long testrayRunId) throws Exception {
        String message;
        HashMap properties = HashMapBuilder.put((Object)"attachments", (Object)this._addTestrayAttachments(testcaseNode)).put((Object)"closedDate", (Object)testrayBuildTime).put((Object)"dueStatus", () -> {
            String testrayTestcaseStatus = (String)testrayCasePropertiesMap.get("testray.testcase.status");
            if (testrayTestcaseStatus.equals("blocked")) {
                return "BLOCKED";
            }
            if (testrayTestcaseStatus.equals("dnr")) {
                return "DIDNOTRUN";
            }
            if (testrayTestcaseStatus.equals("failed")) {
                return "FAILED";
            }
            if (testrayTestcaseStatus.equals("in-progress")) {
                return "INPROGRESS";
            }
            if (testrayTestcaseStatus.equals("passed")) {
                return "PASSED";
            }
            if (testrayTestcaseStatus.equals("test-fix")) {
                return "TESTFIX";
            }
            return "UNTESTED";
        }).put((Object)"r_buildToCaseResult_c_buildId", (Object)testrayBuildId).put((Object)"r_caseToCaseResult_c_caseId", (Object)testrayCaseId).put((Object)"r_componentToCaseResult_c_componentId", (Object)testrayComponentId).put((Object)"r_runToCaseResult_c_runId", (Object)testrayRunId).put((Object)"startDate", (Object)testrayBuildTime).put((Object)"warnings", (Object)((Integer)testrayCasePropertiesMap.get("testray.testcase.warnings"))).build();
        Element element = (Element)testcaseNode;
        NodeList nodeList = element.getElementsByTagName("failure");
        Node failureNode = nodeList.item(0);
        if (failureNode != null && !(message = this._getAttributeValue("message", failureNode)).isEmpty()) {
            properties.put("errors", message);
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "CaseResult", this._objectEntryManager, properties);
        return objectEntry.getId();
    }

    private long _getTestrayCaseTypeId(long companyId, String testrayCaseTypeName) throws Exception {
        String objectEntryIdsKey = "CaseType#" + testrayCaseTypeName;
        long testrayCaseTypeId = this._getObjectEntryId(companyId, "name eq '" + testrayCaseTypeName + "'", "CaseType", objectEntryIdsKey);
        if (testrayCaseTypeId != 0L) {
            return testrayCaseTypeId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "CaseType", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayCaseTypeName).build());
        testrayCaseTypeId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayCaseTypeId);
        return testrayCaseTypeId;
    }

    private long _getTestrayComponentId(long companyId, String testrayComponentName, long testrayProjectId, long testrayTeamId) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Component#", testrayComponentName, "#ProjectId#", testrayProjectId});
        long testrayComponentId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayComponentName, "'"}), "Component", objectEntryIdsKey);
        if (testrayComponentId != 0L) {
            return testrayComponentId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Component", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayComponentName).put((Object)"r_projectToComponents_c_projectId", (Object)testrayProjectId).put((Object)"r_teamToComponents_c_teamId", (Object)testrayTeamId).build());
        testrayComponentId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayComponentId);
        return testrayComponentId;
    }

    private long _getTestrayFactorCategoryId(long companyId, String testrayFactorCategoryName) throws Exception {
        String objectEntryIdsKey = "FactorCategory#" + testrayFactorCategoryName;
        long testrayFactorCategoryId = this._getObjectEntryId(companyId, "name eq '" + testrayFactorCategoryName + "'", "FactorCategory", objectEntryIdsKey);
        if (testrayFactorCategoryId != 0L) {
            return testrayFactorCategoryId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "FactorCategory", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayFactorCategoryName).build());
        testrayFactorCategoryId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayFactorCategoryId);
        return testrayFactorCategoryId;
    }

    private long _getTestrayFactorOptionId(long companyId, long testrayFactorCategoryId, String testrayFactorOptionName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"FactorOption#", testrayFactorOptionName, "#FactorCategoryId#", testrayFactorCategoryId});
        long testrayFactorOptionId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"factorCategoryId eq '", testrayFactorCategoryId, "' and name eq '", testrayFactorOptionName, "'"}), "FactorOption", objectEntryIdsKey);
        if (testrayFactorOptionId != 0L) {
            return testrayFactorOptionId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "FactorOption", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayFactorOptionName).put((Object)"r_factorCategoryToOptions_c_factorCategoryId", (Object)testrayFactorCategoryId).build());
        testrayFactorOptionId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayFactorOptionId);
        return testrayFactorOptionId;
    }

    private long _getTestrayProductVersionId(long companyId, String testrayProductVersionName, long testrayProjectId) throws Exception {
        String objectEntryIdsKey = "ProductVersion#" + testrayProductVersionName;
        long testrayProductVersionId = this._getObjectEntryId(companyId, "name eq '" + testrayProductVersionName + "'", "ProductVersion", objectEntryIdsKey);
        if (testrayProductVersionId != 0L) {
            return testrayProductVersionId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "ProductVersion", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayProductVersionName).put((Object)"r_projectToProductVersions_c_projectId", (Object)testrayProjectId).build());
        testrayProductVersionId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayProductVersionId);
        return testrayProductVersionId;
    }

    private long _getTestrayProjectId(long companyId, String testrayProjectName) throws Exception {
        String objectEntryIdsKey = "Project#" + testrayProjectName;
        long testrayProjectId = this._getObjectEntryId(companyId, "name eq '" + testrayProjectName + "'", "Project", objectEntryIdsKey);
        if (testrayProjectId != 0L) {
            return testrayProjectId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Project", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayProjectName).build());
        testrayProjectId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayProjectId);
        return testrayProjectId;
    }

    private long _getTestrayRoutineId(long companyId, long testrayProjectId, String testrayRoutineName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Routine#", testrayRoutineName, "#ProjectId#", testrayProjectId});
        long testrayRoutineId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayRoutineName, "'"}), "Routine", objectEntryIdsKey);
        if (testrayRoutineId != 0L) {
            return testrayRoutineId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Routine", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayRoutineName).put((Object)"r_routineToProjects_c_projectId", (Object)testrayProjectId).build());
        testrayRoutineId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayRoutineId);
        return testrayRoutineId;
    }

    private String _getTestrayRunEnvironmentHash(long companyId, Element element, long testrayRunId) throws Exception {
        StringBundler sb = new StringBundler();
        NodeList environmentNodeList = element.getElementsByTagName("environment");
        for (int i = 0; i < environmentNodeList.getLength(); ++i) {
            Node node = environmentNodeList.item(i);
            if (!node.hasAttributes()) continue;
            String testrayFactorCategoryName = this._getAttributeValue("type", node);
            long testrayFactorCategoryId = this._getTestrayFactorCategoryId(companyId, testrayFactorCategoryName);
            String testrayFactorOptionName = this._getAttributeValue("option", node);
            long testrayFactorOptionId = this._getTestrayFactorOptionId(companyId, testrayFactorCategoryId, testrayFactorOptionName);
            this._addTestrayFactor(testrayFactorCategoryId, testrayFactorCategoryName, testrayFactorOptionId, testrayFactorOptionName, testrayRunId);
            sb.append(testrayFactorCategoryId);
            sb.append(testrayFactorOptionId);
        }
        String testrayFactorsString = sb.toString();
        return String.valueOf(testrayFactorsString.hashCode());
    }

    private long _getTestrayRunId(long companyId, Element element, Map<String, String> propertiesMap, long testrayBuildId, String testrayRunName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Run#", testrayRunName, "#BuildId#", testrayBuildId});
        long testrayRunId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"buildId eq '", testrayBuildId, "' and name eq '", testrayRunName, "'"}), "Run", objectEntryIdsKey);
        if (testrayRunId != 0L) {
            return testrayRunId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Run", this._objectEntryManager, HashMapBuilder.put((Object)"externalReferencePK", (Object)propertiesMap.get("testray.run.id")).put((Object)"externalReferenceType", (Object)1).put((Object)"jenkinsJobKey", (Object)propertiesMap.get("jenkins.job.id")).put((Object)"name", (Object)testrayRunName).put((Object)"number", (Object)ObjectEntryUtil.increment(companyId, this._defaultDTOConverterContext, "buildId eq '" + testrayBuildId + "'", "number", "Run", this._objectEntryManager, new Sort[]{new Sort("nestedFieldArray.value_long#number", true)})).put((Object)"r_buildToRuns_c_buildId", (Object)testrayBuildId).build());
        testrayRunId = objectEntry.getId();
        objectEntry.getProperties().put("environmentHash", this._getTestrayRunEnvironmentHash(companyId, element, testrayRunId));
        ObjectEntryUtil.updateObjectEntry(this._defaultDTOConverterContext, "Run", objectEntry, objectEntry.getId(), this._objectEntryManager);
        this._objectEntryIds.put(objectEntryIdsKey, testrayRunId);
        return testrayRunId;
    }

    private long _getTestrayTeamId(long companyId, long testrayProjectId, String testrayTeamName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Team#", testrayTeamName, "#ProjectId#", testrayProjectId});
        long testrayTeamId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayTeamName, "'"}), "Team", objectEntryIdsKey);
        if (testrayTeamId != 0L) {
            return testrayTeamId;
        }
        ObjectEntry objectEntry = ObjectEntryUtil.addObjectEntry(this._defaultDTOConverterContext, "Team", this._objectEntryManager, HashMapBuilder.put((Object)"name", (Object)testrayTeamName).put((Object)"r_projectToTeams_c_projectId", (Object)testrayProjectId).build());
        this._objectEntryIds.put(objectEntryIdsKey, objectEntry.getId());
        return objectEntry.getId();
    }

    private void _invoke(UnsafeRunnable<Exception> unsafeRunnable) throws Exception {
        long startTime = System.currentTimeMillis();
        unsafeRunnable.run();
        if (_log.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Invoking line ", stackTraceElement.getLineNumber(), " took ", System.currentTimeMillis() - startTime, " ms"}));
        }
    }

    private void _load(long companyId) throws Exception {
        ObjectEntryUtil.loadObjectDefinitions(companyId, this._objectDefinitionLocalService);
        this._loadTestrayCaseTypes(companyId);
        this._loadTestrayComponents(companyId);
        this._loadTestrayFactorCategories(companyId);
        this._loadTestrayFactorOptions(companyId);
        this._loadTestrayProjects(companyId);
        this._loadTestrayTeams(companyId);
    }

    private void _loadTestrayCaseTypes(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, null, "CaseType", this._objectEntryManager, null);
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put("CaseType#" + (String)ObjectEntryUtil.getProperty("name", objectEntry), objectEntry.getId());
        }
    }

    private void _loadTestrayComponents(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, null, "Component", this._objectEntryManager, null);
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put(StringBundler.concat((Object[])new Object[]{"Component#", (String)ObjectEntryUtil.getProperty("name", objectEntry), "#TeamId#", (Long)ObjectEntryUtil.getProperty("r_teamToComponents_c_teamId", objectEntry)}), objectEntry.getId());
        }
    }

    private void _loadTestrayFactorCategories(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, null, "FactorCategory", this._objectEntryManager, null);
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put("FactorCategory#" + (String)ObjectEntryUtil.getProperty("name", objectEntry), objectEntry.getId());
        }
    }

    private void _loadTestrayFactorOptions(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, null, "FactorOption", this._objectEntryManager, null);
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put(StringBundler.concat((Object[])new Object[]{"FactorOption#", (String)ObjectEntryUtil.getProperty("name", objectEntry), "#FactorCategoryId#", (Long)ObjectEntryUtil.getProperty("r_factorCategoryToOptions_c_factorCategoryId", objectEntry)}), objectEntry.getId());
        }
    }

    private void _loadTestrayProjects(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, null, "Project", this._objectEntryManager, null);
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put("Project#" + (String)ObjectEntryUtil.getProperty("name", objectEntry), objectEntry.getId());
        }
    }

    private void _loadTestrayTeams(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = ObjectEntryUtil.getObjectEntries(null, companyId, this._defaultDTOConverterContext, null, "Team", this._objectEntryManager, null);
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put(StringBundler.concat((Object[])new Object[]{"Team#", (String)ObjectEntryUtil.getProperty("name", objectEntry), "#ProjectId#", (Long)ObjectEntryUtil.getProperty("r_projectToTeams_c_projectIds", objectEntry)}), objectEntry.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processArchive(long companyId, byte[] bytes) throws Exception {
        Path tempFilePath;
        block11: {
            Path tempDirectoryPath = null;
            tempFilePath = null;
            try {
                tempDirectoryPath = Files.createTempDirectory(null, new FileAttribute[0]);
                tempFilePath = Files.createTempFile(null, null, new FileAttribute[0]);
                Files.write(tempFilePath, bytes, new OpenOption[0]);
                Archiver archiver = ArchiverFactory.createArchiver((String)"tar");
                File tempDirectoryFile = tempDirectoryPath.toFile();
                archiver.extract(tempFilePath.toFile(), tempDirectoryFile);
                DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                for (File file : tempDirectoryFile.listFiles()) {
                    try {
                        Document document = documentBuilder.parse(file);
                        this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._processDocument(companyId, document)));
                    }
                    catch (Exception exception) {
                        _log.error((Throwable)exception);
                    }
                    finally {
                        file.delete();
                    }
                }
                if (tempDirectoryPath == null) break block11;
            }
            catch (Throwable throwable) {
                if (tempDirectoryPath != null) {
                    Files.deleteIfExists(tempDirectoryPath);
                }
                if (tempFilePath != null) {
                    Files.deleteIfExists(tempFilePath);
                }
                throw throwable;
            }
            Files.deleteIfExists(tempDirectoryPath);
        }
        if (tempFilePath != null) {
            Files.deleteIfExists(tempFilePath);
        }
    }

    private void _processDocument(long companyId, Document document) throws Exception {
        Element element = document.getDocumentElement();
        Map<String, String> propertiesMap = this._getPropertiesMap(element);
        long testrayProjectId = this._getTestrayProjectId(companyId, propertiesMap.get("testray.project.name"));
        long testrayRoutineId = this._getTestrayRoutineId(companyId, testrayProjectId, propertiesMap.get("testray.build.type"));
        long testrayBuildId = this._getTestrayBuildId(companyId, propertiesMap, propertiesMap.get("testray.build.name"), testrayProjectId, testrayRoutineId);
        long testrayRunId = this._getTestrayRunId(companyId, element, propertiesMap, testrayBuildId, propertiesMap.get("testray.run.id"));
        this._addTestrayCases(companyId, element, testrayBuildId, propertiesMap.get("testray.build.time"), testrayProjectId, testrayRunId);
        ObjectEntry testrayRoutineObjectEntry = ObjectEntryUtil.getObjectEntry(this._defaultDTOConverterContext, "Routine", testrayRoutineId, this._objectEntryManager);
        if (!((Boolean)ObjectEntryUtil.getProperty("autoanalyze", testrayRoutineObjectEntry)).booleanValue()) {
            return;
        }
        ObjectEntry testrayRunObjectEntry1 = ObjectEntryUtil.getObjectEntry(this._defaultDTOConverterContext, "Run", testrayRunId, this._objectEntryManager);
        ObjectEntry testrayRunObjectEntry2 = this._fetchLatestTestrayRunObjectEntry(companyId, (String)ObjectEntryUtil.getProperty("environmentHash", testrayRunObjectEntry1), testrayRoutineObjectEntry.getId(), testrayRunId);
        if (testrayRunObjectEntry2 == null) {
            return;
        }
        TestrayUtil.autofillTestrayRuns(companyId, this._defaultDTOConverterContext, this._objectEntryManager, testrayRunObjectEntry1, testrayRunObjectEntry2);
    }

    private void _uploadToTestray(long companyId, UnicodeProperties unicodeProperties) throws Exception {
        String s3APIKey = unicodeProperties.getProperty("s3APIKey");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(s3APIKey.getBytes());){
            long filesCountThreshold = GetterUtil.getLong((String)unicodeProperties.getProperty("filesCountThreshold"), (long)-1L);
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)inputStream))).build().getService();
            String s3InboxFolderName = unicodeProperties.getProperty("s3InboxFolderName");
            Page page = storage.list(unicodeProperties.getProperty("s3BucketName"), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(s3InboxFolderName + "/"))});
            for (Blob blob : page.iterateAll()) {
                if (filesCountThreshold == 0L) {
                    break;
                }
                String name = blob.getName();
                if (name.equals(s3InboxFolderName + "/")) continue;
                try {
                    this._processArchive(companyId, blob.getContent(new Blob.BlobSourceOption[0]));
                    blob.copyTo(unicodeProperties.getProperty("s3BucketName"), name.replaceFirst(s3InboxFolderName, unicodeProperties.getProperty("s3ProcessedFolderName")), new Blob.BlobSourceOption[0]);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                    blob.copyTo(unicodeProperties.getProperty("s3BucketName"), name.replaceFirst(s3InboxFolderName, unicodeProperties.getProperty("s3ErroredFolderName")), new Blob.BlobSourceOption[0]);
                }
                blob.delete(new Blob.BlobSourceOption[0]);
                --filesCountThreshold;
            }
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to authenticate with GCP");
            throw new PortalException("Unable to authenticate with GCP", (Throwable)ioException);
        }
    }
}

