/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.security.permission.contributor;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.security.permission.contributor.PermissionSQLContributor;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.model.SharingEntryTable;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SharingPermissionSQLContributor
implements PermissionSQLContributor {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;
    private final SharingConfigurationFactory _sharingConfigurationFactory;
    private final SharingEntryLocalService _sharingEntryLocalService;
    private final UserGroupLocalService _userGroupLocalService;
    private final UserLocalService _userLocalService;

    public SharingPermissionSQLContributor(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService, SharingConfigurationFactory sharingConfigurationFactory, SharingEntryLocalService sharingEntryLocalService, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
        this._sharingConfigurationFactory = sharingConfigurationFactory;
        this._sharingEntryLocalService = sharingEntryLocalService;
        this._userGroupLocalService = userGroupLocalService;
        this._userLocalService = userLocalService;
    }

    public void collectPermittedClassPKs(String className, long userId, long[] groupIds, Set<Long> permittedClassPKs) {
        SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getSystemSharingConfiguration();
        if (!sharingConfiguration.isEnabled()) {
            return;
        }
        List sharingEntries = this._sharingEntryLocalService.getToUserSharingEntries(userId, this._classNameLocalService.getClassNameId(className));
        if (sharingEntries.isEmpty()) {
            return;
        }
        HashSet<Long> disabledGroupIds = new HashSet<Long>();
        for (long groupId : groupIds) {
            SharingConfiguration groupSharingConfiguration;
            if (groupId == 0L || (groupSharingConfiguration = this._getSharingConfiguration(groupId)).isEnabled()) continue;
            disabledGroupIds.add(groupId);
        }
        Set userGroupIds = SetUtil.fromArray((long[])this._userLocalService.getUserGroupPrimaryKeys(userId));
        for (SharingEntry sharingEntry : sharingEntries) {
            if (disabledGroupIds.contains(sharingEntry.getGroupId()) || !userGroupIds.contains(sharingEntry.getToUserGroupId())) continue;
            permittedClassPKs.add(sharingEntry.getClassPK());
        }
    }

    public Predicate getPermissionPredicate(PermissionChecker permissionChecker, String className, Column<?, Long> classPKColumn, long[] groupIds) {
        SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getSystemSharingConfiguration();
        if (!sharingConfiguration.isEnabled()) {
            return null;
        }
        ArrayList<Long> disableGroupIds = new ArrayList<Long>();
        if (groupIds != null) {
            for (long groupId : groupIds) {
                SharingConfiguration groupSharingConfiguration;
                if (groupId == 0L || (groupSharingConfiguration = this._getSharingConfiguration(groupId)).isEnabled()) continue;
                disableGroupIds.add(groupId);
            }
            if (disableGroupIds.size() == groupIds.length) {
                return null;
            }
        }
        return classPKColumn.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{SharingEntryTable.INSTANCE.classPK}).from((Table)SharingEntryTable.INSTANCE).where(() -> {
            Predicate predicate = this._getUserAndUserGroupPredicate(permissionChecker).and((Expression)SharingEntryTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className)));
            if (disableGroupIds.isEmpty()) {
                return predicate;
            }
            return predicate.and((Expression)SharingEntryTable.INSTANCE.groupId.notIn((Object[])disableGroupIds.toArray(new Long[0])));
        }));
    }

    public String getPermissionSQL(String className, String classPKField, String groupIdField, long[] groupIds) {
        SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getSystemSharingConfiguration();
        if (!sharingConfiguration.isEnabled()) {
            return "";
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        StringBundler sb = new StringBundler(7);
        sb.append(classPKField);
        sb.append(" IN (SELECT SharingEntry.classPK FROM SharingEntry WHERE ");
        this._addDisabledGroupsSQL(sb, groupIds);
        List userGroups = this._userGroupLocalService.getUserUserGroups(permissionChecker.getUserId());
        sb.append("(");
        if (!userGroups.isEmpty()) {
            sb.append("(SharingEntry.toUserGroupId IN ( ");
            sb.append(StringUtil.merge((long[])TransformUtil.transformToLongArray((Collection)userGroups, UserGroupModel::getUserGroupId), (String)","));
            sb.append(")) OR ");
        }
        sb.append("(SharingEntry.toUserId = ");
        sb.append(permissionChecker.getUserId());
        sb.append(")) AND (SharingEntry.classNameId = ");
        sb.append(this._classNameLocalService.getClassNameId(className));
        sb.append("))");
        return sb.toString();
    }

    private void _addDisabledGroupsSQL(StringBundler sb, long[] groupIds) {
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return;
        }
        int groupCount = 0;
        for (long groupId : groupIds) {
            SharingConfiguration sharingConfiguration;
            if (groupId == 0L || (sharingConfiguration = this._getSharingConfiguration(groupId)).isEnabled()) continue;
            if (groupCount == 0) {
                sb.append("(SharingEntry.groupId NOT IN (");
            } else {
                sb.append(", ");
            }
            sb.append(groupId);
            ++groupCount;
        }
        if (groupCount > 0) {
            sb.append(")) AND");
        }
    }

    private SharingConfiguration _getSharingConfiguration(long groupId) {
        try {
            return this._sharingConfigurationFactory.getGroupSharingConfiguration(this._groupLocalService.getGroup(groupId));
        }
        catch (PortalException portalException) {
            return (SharingConfiguration)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private Predicate _getUserAndUserGroupPredicate(PermissionChecker permissionChecker) {
        return SharingEntryTable.INSTANCE.toUserId.eq((Object)permissionChecker.getUserId()).or(() -> {
            User user = permissionChecker.getUser();
            List userGroups = user.getUserGroups();
            if (userGroups.isEmpty()) {
                return null;
            }
            return SharingEntryTable.INSTANCE.toUserGroupId.in((Object[])((Long[])TransformUtil.transformToArray((Collection)userGroups, UserGroupModel::getUserGroupId, Long.class)));
        });
    }
}

