/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.search.spi.model.index.contributor;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.sharing.interpreter.SharingEntryInterpreter;
import com.liferay.sharing.interpreter.SharingEntryInterpreterProvider;
import com.liferay.sharing.model.SharingEntry;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.sharing.model.SharingEntry"}, service={ModelDocumentContributor.class})
public class SharingEntryModelDocumentContributor
implements ModelDocumentContributor<SharingEntry> {
    private static final Log _log = LogFactoryUtil.getLog(SharingEntryModelDocumentContributor.class);
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private SharingEntryInterpreterProvider _sharingEntryInterpreterProvider;

    public void contribute(Document document, SharingEntry sharingEntry) {
        document.addKeyword("classNameId", sharingEntry.getClassNameId());
        document.addKeyword("classPK", String.valueOf(sharingEntry.getClassPK()));
        document.addDate("createDate", sharingEntry.getCreateDate());
        document.addDate("modified", sharingEntry.getModifiedDate());
        document.addLocalizedText("title", this._getTitleMap(sharingEntry));
        document.addKeyword("userId", sharingEntry.getUserId());
        document.addLocalizedText("localized_title", this._getTitleMap(sharingEntry), true);
        document.addKeyword("sharingEntryId", String.valueOf(sharingEntry.getSharingEntryId()));
        document.addKeyword("spaceDepotEntry", this._isSpaceDepotEntry(sharingEntry.getGroupId()));
        document.addKeyword("toUserGroupId", String.valueOf(sharingEntry.getToUserGroupId()));
        document.addKeyword("toUserId", String.valueOf(sharingEntry.getToUserId()));
    }

    private Map<Locale, String> _getTitleMap(SharingEntry sharingEntry) {
        SharingEntryInterpreter sharingEntryInterpreter = this._sharingEntryInterpreterProvider.getSharingEntryInterpreter(sharingEntry);
        if (sharingEntryInterpreter == null) {
            return null;
        }
        return sharingEntryInterpreter.getTitleMap(sharingEntry);
    }

    private boolean _isSpaceDepotEntry(long groupId) {
        DepotEntry depotEntry;
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get group " + groupId + " while indexing document"));
            }
            return false;
        }
        return group.isDepot() && (depotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(groupId)) != null && Objects.equals(depotEntry.getType(), 1);
    }
}

