/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.sharing.interpreter.SharingEntryInterpreter;
import com.liferay.sharing.interpreter.SharingEntryInterpreterProvider;
import com.liferay.sharing.model.SharingEntry;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.sharing.model.SharingEntry"}, service={ModelDocumentContributor.class})
public class SharingEntryModelDocumentContributor
implements ModelDocumentContributor<SharingEntry> {
    @Reference
    private SharingEntryInterpreterProvider _sharingEntryInterpreterProvider;

    public void contribute(Document document, SharingEntry sharingEntry) {
        document.addKeyword("classNameId", sharingEntry.getClassNameId());
        document.addKeyword("classPK", String.valueOf(sharingEntry.getClassPK()));
        document.addDate("createDate", sharingEntry.getCreateDate());
        document.addDate("modified", sharingEntry.getModifiedDate());
        document.addLocalizedText("title", this._getTitleMap(sharingEntry));
        document.addKeyword("userId", sharingEntry.getUserId());
        document.addLocalizedText("localized_title", this._getTitleMap(sharingEntry), true);
        document.addKeyword("sharingEntryId", String.valueOf(sharingEntry.getSharingEntryId()));
        document.addKeyword("toUserGroupId", String.valueOf(sharingEntry.getToUserGroupId()));
        document.addKeyword("toUserId", String.valueOf(sharingEntry.getToUserId()));
    }

    private Map<Locale, String> _getTitleMap(SharingEntry sharingEntry) {
        SharingEntryInterpreter sharingEntryInterpreter = this._sharingEntryInterpreterProvider.getSharingEntryInterpreter(sharingEntry);
        if (sharingEntryInterpreter == null) {
            return null;
        }
        return sharingEntryInterpreter.getTitleMap(sharingEntry);
    }
}

