/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.service.impl;

import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupTable;
import com.liferay.portal.kernel.model.Users_UserGroupsTable;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.sharing.exception.DuplicateSharingEntryException;
import com.liferay.sharing.exception.InvalidSharingEntryActionException;
import com.liferay.sharing.exception.InvalidSharingEntryExpirationDateException;
import com.liferay.sharing.exception.InvalidSharingEntryUserAndUserGroupException;
import com.liferay.sharing.exception.InvalidSharingEntryUserException;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.model.SharingEntryTable;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.base.SharingEntryLocalServiceBaseImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.sharing.model.SharingEntry"}, service={AopService.class})
public class SharingEntryLocalServiceImpl
extends SharingEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SharingEntryLocalServiceImpl.class);
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public SharingEntry addOrUpdateSharingEntry(String externalReferenceCode, long userId, long toUserGroupId, long toUserId, long classNameId, long classPK, long groupId, boolean shareable, Collection<SharingEntryAction> sharingEntryActions, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = this.sharingEntryPersistence.fetchByTUG_TU_C_C(toUserGroupId, toUserId, classNameId, classPK);
        if (sharingEntry == null) {
            return this.sharingEntryLocalService.addSharingEntry(externalReferenceCode, userId, toUserGroupId, toUserId, classNameId, classPK, groupId, shareable, sharingEntryActions, expirationDate, serviceContext);
        }
        return this.sharingEntryLocalService.updateSharingEntry(userId, sharingEntry.getSharingEntryId(), sharingEntryActions, shareable, expirationDate, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SharingEntry addSharingEntry(String externalReferenceCode, long userId, long toUserGroupId, long toUserId, long classNameId, long classPK, long groupId, boolean shareable, Collection<SharingEntryAction> sharingEntryActions, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        this._validateSharingEntryActions(sharingEntryActions);
        this._validateUsersAndUserGroup(userId, toUserGroupId, toUserId);
        this._validateExpirationDate(expirationDate);
        SharingEntry existingSharingEntry = this.sharingEntryPersistence.fetchByTUG_TU_C_C(toUserGroupId, toUserId, classNameId, classPK);
        if (existingSharingEntry != null) {
            throw new DuplicateSharingEntryException(StringBundler.concat((Object[])new Object[]{"A sharing entry already exists for user ", toUserId, " with classNameId ", classNameId, " and classPK ", classPK}));
        }
        long sharingEntryId = this.counterLocalService.increment();
        SharingEntry sharingEntry = this.sharingEntryPersistence.create(sharingEntryId);
        sharingEntry.setUuid(serviceContext.getUuid());
        sharingEntry.setGroupId(groupId);
        User user = this._userLocalService.getUser(userId);
        sharingEntry.setExternalReferenceCode(externalReferenceCode);
        sharingEntry.setCompanyId(user.getCompanyId());
        sharingEntry.setUserId(user.getUserId());
        sharingEntry.setUserName(user.getFullName());
        sharingEntry.setToUserGroupId(toUserGroupId);
        sharingEntry.setToUserId(toUserId);
        sharingEntry.setClassNameId(classNameId);
        sharingEntry.setClassPK(classPK);
        sharingEntry.setShareable(shareable);
        sharingEntry.setActionIds(this._getActionIds(sharingEntryActions));
        sharingEntry.setExpirationDate(expirationDate);
        SharingEntry newSharingEntry = (SharingEntry)this.sharingEntryPersistence.update((BaseModel)sharingEntry);
        String className = this._portal.getClassName(classNameId);
        Indexer indexer = this._indexerRegistry.getIndexer(className);
        if (indexer != null) {
            indexer.reindex(className, classPK);
        }
        return newSharingEntry;
    }

    public void deleteExpiredEntries() {
        this.sharingEntryPersistence.removeByLtExpirationDate(DateUtil.newDate());
    }

    public void deleteGroupSharingEntries(long groupId) {
        List sharingEntries = this.sharingEntryPersistence.findByGroupId(groupId);
        for (SharingEntry sharingEntry : sharingEntries) {
            this.deleteSharingEntry(sharingEntry);
        }
    }

    public void deleteSharingEntries(long classNameId, long classPK) {
        List sharingEntries = this.sharingEntryPersistence.findByC_C(classNameId, classPK);
        for (SharingEntry sharingEntry : sharingEntries) {
            this.deleteSharingEntry(sharingEntry);
        }
    }

    @Override
    public SharingEntry deleteSharingEntry(long sharingEntryId) throws PortalException {
        return this.deleteSharingEntry(this.getSharingEntry(sharingEntryId));
    }

    public SharingEntry deleteSharingEntry(long toUserId, long classNameId, long classPK) throws PortalException {
        SharingEntry sharingEntry = this.sharingEntryPersistence.findByTUG_TU_C_C(0L, toUserId, classNameId, classPK);
        return this.deleteSharingEntry(sharingEntry);
    }

    @Override
    @SystemEvent(type=1)
    public SharingEntry deleteSharingEntry(SharingEntry sharingEntry) {
        SharingEntry deletedSharingEntry;
        block3: {
            String className = sharingEntry.getClassName();
            long classPK = sharingEntry.getClassPK();
            deletedSharingEntry = (SharingEntry)this.sharingEntryPersistence.remove((BaseModel)sharingEntry);
            Indexer indexer = this._indexerRegistry.getIndexer(className);
            if (indexer != null) {
                try {
                    indexer.reindex(className, classPK);
                }
                catch (SearchException searchException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to index sharing entry for class name ", className, " and primary key ", classPK}), (Throwable)searchException);
                }
            }
        }
        return deletedSharingEntry;
    }

    public SharingEntry deleteSharingEntryByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        return this.sharingEntryLocalService.deleteSharingEntry(this.getSharingEntryByExternalReferenceCode(externalReferenceCode, groupId));
    }

    public void deleteToUserSharingEntries(long toUserId) {
        List sharingEntries = this.sharingEntryPersistence.findByToUserId(toUserId);
        for (SharingEntry sharingEntry : sharingEntries) {
            this.deleteSharingEntry(sharingEntry);
        }
    }

    public SharingEntry fetchSharingEntry(long toUserId, long classNameId, long classPK) {
        return this.sharingEntryPersistence.fetchByTUG_TU_C_C(0L, toUserId, classNameId, classPK);
    }

    public List<SharingEntry> getFromUserSharingEntries(long fromUserId, long classNameId, int start, int end, OrderByComparator<SharingEntry> orderByComparator) {
        return this.sharingEntryFinder.findByUserId(fromUserId, classNameId, start, end, orderByComparator);
    }

    public int getFromUserSharingEntriesCount(long fromUserId, long classNameId) {
        return this.sharingEntryFinder.countByUserId(fromUserId, classNameId);
    }

    public List<SharingEntry> getGroupSharingEntries(long groupId) {
        return this.sharingEntryPersistence.findByGroupId(groupId);
    }

    public int getGroupSharingEntriesCount(long groupId) {
        return this.sharingEntryPersistence.countByGroupId(groupId);
    }

    public List<SharingEntry> getSharingEntries(long classNameId, long classPK) {
        return this.sharingEntryPersistence.findByC_C(classNameId, classPK);
    }

    public List<SharingEntry> getSharingEntries(long classNameId, long classPK, int start, int end) {
        return this.sharingEntryPersistence.findByC_C(classNameId, classPK, start, end);
    }

    public int getSharingEntriesCount(long classNameId, long classPK) {
        return this.sharingEntryPersistence.countByC_C(classNameId, classPK);
    }

    public SharingEntry getSharingEntry(long toUserId, long classNameId, long classPK) throws PortalException {
        return this.sharingEntryPersistence.findByTUG_TU_C_C(0L, toUserId, classNameId, classPK);
    }

    public List<SharingEntry> getToUserSharingEntries(long toUserId) {
        return this.sharingEntryPersistence.findByToUserId(toUserId);
    }

    public List<SharingEntry> getToUserSharingEntries(long toUserId, int start, int end) {
        return this.sharingEntryPersistence.findByToUserId(toUserId, start, end);
    }

    public List<SharingEntry> getToUserSharingEntries(long toUserId, long classNameId) {
        return this.sharingEntryPersistence.findByTU_C(toUserId, classNameId);
    }

    public List<SharingEntry> getToUserSharingEntries(long toUserId, long classNameId, int start, int end, OrderByComparator<SharingEntry> orderByComparator) {
        if (classNameId > 0L) {
            return this.sharingEntryPersistence.findByTU_C(toUserId, classNameId, start, end, orderByComparator);
        }
        return this.sharingEntryPersistence.findByToUserId(toUserId, start, end, orderByComparator);
    }

    public int getToUserSharingEntriesCount(long toUserId) {
        return this.sharingEntryPersistence.countByToUserId(toUserId);
    }

    public int getToUserSharingEntriesCount(long toUserId, long classNameId) {
        if (classNameId > 0L) {
            return this.sharingEntryPersistence.countByTU_C(toUserId, classNameId);
        }
        return this.sharingEntryPersistence.countByToUserId(toUserId);
    }

    public boolean hasShareableSharingPermission(long toUserId, long classNameId, long classPK, SharingEntryAction sharingEntryAction) {
        int sharingEntriesCount = this._getSharingEntriesCount(classNameId, classPK, true, sharingEntryAction, toUserId);
        return sharingEntriesCount > 0;
    }

    public boolean hasSharingPermission(long toUserId, long classNameId, long classPK, SharingEntryAction sharingEntryAction) {
        int sharingEntriesCount = this._getSharingEntriesCount(classNameId, classPK, null, sharingEntryAction, toUserId);
        return sharingEntriesCount > 0;
    }

    @Deprecated
    public SharingEntry updateSharingEntry(long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        return this.updateSharingEntry(serviceContext.getUserId(), sharingEntryId, sharingEntryActions, shareable, expirationDate, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public SharingEntry updateSharingEntry(long userId, long sharingEntryId, Collection<SharingEntryAction> sharingEntryActions, boolean shareable, Date expirationDate, ServiceContext serviceContext) throws PortalException {
        SharingEntry sharingEntry = this.sharingEntryPersistence.findByPrimaryKey(sharingEntryId);
        this._validateSharingEntryActions(sharingEntryActions);
        this._validateExpirationDate(expirationDate);
        sharingEntry.setUserId(userId);
        sharingEntry.setShareable(shareable);
        sharingEntry.setActionIds(this._getActionIds(sharingEntryActions));
        sharingEntry.setExpirationDate(expirationDate);
        return (SharingEntry)this.sharingEntryPersistence.update((BaseModel)sharingEntry);
    }

    private long _getActionIds(Collection<SharingEntryAction> sharingEntryActions) {
        long actionIds = 0L;
        for (SharingEntryAction sharingEntryAction : sharingEntryActions) {
            actionIds |= sharingEntryAction.getBitwiseValue();
        }
        return actionIds;
    }

    private int _getSharingEntriesCount(long classNameId, long classPK, Boolean shareable, SharingEntryAction sharingEntryAction, long toUserId) {
        return this.sharingEntryLocalService.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)SharingEntryTable.INSTANCE).where(DSLFunctionFactoryUtil.bitAnd((Expression)SharingEntryTable.INSTANCE.actionIds, (long)sharingEntryAction.getBitwiseValue()).eq((Object)sharingEntryAction.getBitwiseValue()).and((Expression)SharingEntryTable.INSTANCE.classNameId.eq((Object)classNameId)).and((Expression)SharingEntryTable.INSTANCE.classPK.eq((Object)classPK)).and(() -> {
            if (shareable == null) {
                return null;
            }
            return SharingEntryTable.INSTANCE.shareable.eq((Object)shareable);
        }).and((Expression)SharingEntryTable.INSTANCE.toUserId.eq((Object)toUserId).or((Expression)SharingEntryTable.INSTANCE.toUserGroupId.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{UserGroupTable.INSTANCE.userGroupId}).from((Table)UserGroupTable.INSTANCE).innerJoinON((Table)Users_UserGroupsTable.INSTANCE, UserGroupTable.INSTANCE.userGroupId.eq((Expression)Users_UserGroupsTable.INSTANCE.userGroupId)).where(Users_UserGroupsTable.INSTANCE.userId.eq((Object)toUserId)))).withParentheses())));
    }

    private void _validateExpirationDate(Date expirationDate) throws InvalidSharingEntryExpirationDateException {
        if (expirationDate != null && expirationDate.before(DateUtil.newDate())) {
            throw new InvalidSharingEntryExpirationDateException("Expiration date is in the past");
        }
    }

    private void _validateSharingEntryActions(Collection<SharingEntryAction> sharedEntryActions) throws InvalidSharingEntryActionException {
        if (sharedEntryActions.isEmpty()) {
            throw new InvalidSharingEntryActionException("Shared entry actions is empty");
        }
        for (SharingEntryAction curSharingEntryAction : sharedEntryActions) {
            if (curSharingEntryAction != null) continue;
            throw new InvalidSharingEntryActionException("Shared entry actions contains a null value");
        }
        if (!sharedEntryActions.contains(SharingEntryAction.VIEW)) {
            throw new InvalidSharingEntryActionException("Shared entry actions must contain VIEW shared entry action");
        }
    }

    private void _validateUsersAndUserGroup(long fromUserId, long toUserGroupId, long toUserId) throws PortalException {
        if (toUserGroupId > 0L) {
            this._userGroupLocalService.getUserGroup(toUserGroupId);
        }
        if (toUserGroupId > 0L && toUserId > 0L) {
            throw new InvalidSharingEntryUserAndUserGroupException("A sharing entry cannot be associated with a user and a user group at the same time");
        }
        if (toUserId > 0L && fromUserId == toUserId) {
            throw new InvalidSharingEntryUserException("From user cannot be the same as to user");
        }
    }
}

