/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.internal.security.permission.resource;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.security.permission.contributor.PermissionSQLContributor;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.internal.configuration.SharingSystemConfiguration;
import com.liferay.sharing.internal.security.permission.contributor.SharingPermissionSQLContributor;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.security.permission.resource.SharingModelResourcePermissionConfigurator;
import com.liferay.sharing.service.SharingEntryLocalService;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.sharing.internal.configuration.SharingSystemConfiguration"}, service={SharingModelResourcePermissionConfigurator.class})
public class SharingModelResourcePermissionConfiguratorImpl
implements SharingModelResourcePermissionConfigurator {
    private static final Map<String, SharingEntryAction> _sharingEntryActions = SharingModelResourcePermissionConfiguratorImpl._getSharingEntryActions();
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private final Set<String> _modelClassNames = new HashSet<String>();
    @Reference
    private SharingConfigurationFactory _sharingConfigurationFactory;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;
    private ServiceRegistration<PermissionSQLContributor> _sharingPermissionSQLContributorServiceRegistration;
    private SharingSystemConfiguration _sharingSystemConfiguration;

    public <T extends GroupedModel> void configure(ModelResourcePermission<T> modelResourcePermission, Consumer<ModelResourcePermissionLogic<T>> consumer) {
        if (this._sharingSystemConfiguration.enabled()) {
            this._modelClassNames.add(modelResourcePermission.getModelName());
            this._sharingPermissionSQLContributorServiceRegistration.setProperties((Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)this._modelClassNames.toArray()).build());
            consumer.accept(new SharingModelResourcePermissionLogic(this._classNameLocalService.getClassNameId(modelResourcePermission.getModelName())));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._sharingSystemConfiguration = (SharingSystemConfiguration)ConfigurableUtil.createConfigurable(SharingSystemConfiguration.class, properties);
        this._sharingPermissionSQLContributorServiceRegistration = bundleContext.registerService(PermissionSQLContributor.class, (Object)new SharingPermissionSQLContributor(this._classNameLocalService, this._groupLocalService, this._sharingConfigurationFactory), (Dictionary)new HashMapDictionary());
    }

    @Deactivate
    protected void deactivate() {
        this._sharingPermissionSQLContributorServiceRegistration.unregister();
    }

    private static Map<String, SharingEntryAction> _getSharingEntryActions() {
        HashMap<String, SharingEntryAction> sharingEntryActions = new HashMap<String, SharingEntryAction>();
        for (SharingEntryAction sharingEntryAction : SharingEntryAction.values()) {
            sharingEntryActions.put(sharingEntryAction.getActionId(), sharingEntryAction);
        }
        return sharingEntryActions;
    }

    private class SharingModelResourcePermissionLogic<T extends GroupedModel>
    implements ModelResourcePermissionLogic<T> {
        private final long _classNameId;

        public Boolean contains(PermissionChecker permissionChecker, String name, T model, String actionId) throws PortalException {
            SharingEntryAction sharingEntryAction = (SharingEntryAction)_sharingEntryActions.get(actionId);
            if (sharingEntryAction == null) {
                return null;
            }
            long primaryKey = (Long)model.getPrimaryKeyObj();
            if (permissionChecker.hasOwnerPermission(model.getCompanyId(), name, primaryKey, model.getUserId(), actionId) || permissionChecker.hasPermission(model.getGroupId(), name, primaryKey, actionId) || !SharingModelResourcePermissionConfiguratorImpl.this._sharingEntryLocalService.hasSharingPermission(permissionChecker.getUserId(), this._classNameId, primaryKey, sharingEntryAction)) {
                return null;
            }
            SharingConfiguration sharingConfiguration = SharingModelResourcePermissionConfiguratorImpl.this._sharingConfigurationFactory.getGroupSharingConfiguration(SharingModelResourcePermissionConfiguratorImpl.this._groupLocalService.getGroup(model.getGroupId()));
            if (sharingConfiguration.isEnabled()) {
                return true;
            }
            return null;
        }

        private SharingModelResourcePermissionLogic(long classNameId) {
            this._classNameId = classNameId;
        }
    }
}

