/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.search.kql;

import com.liferay.sharepoint.rest.repository.internal.search.kql.AndKQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.NotKQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.NullKQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.OrKQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.RangeKQLQuery;
import com.liferay.sharepoint.rest.repository.internal.search.kql.StringKQLQuery;
import java.util.Arrays;
import java.util.stream.Stream;

public interface KQLQuery {
    public static KQLQuery and(KQLQuery ... kqlQueries) {
        Stream<KQLQuery> queryStream = Arrays.stream(kqlQueries);
        return queryStream.reduce(NullKQLQuery.INSTANCE, (kqlQuery1, kqlQuery2) -> kqlQuery1.and((KQLQuery)kqlQuery2));
    }

    public static KQLQuery eq(String field, String value) {
        return new StringKQLQuery(field, value);
    }

    public static KQLQuery range(String lower, String upper) {
        return new RangeKQLQuery(lower, upper);
    }

    default public KQLQuery and(KQLQuery kqlQuery) {
        if (kqlQuery == NullKQLQuery.INSTANCE) {
            return this;
        }
        return new AndKQLQuery(this, kqlQuery);
    }

    default public KQLQuery not() {
        return new NotKQLQuery(this);
    }

    default public KQLQuery or(KQLQuery kqlQuery) {
        if (kqlQuery == NullKQLQuery.INSTANCE) {
            return this;
        }
        return new OrKQLQuery(this, kqlQuery);
    }

    public String toString();
}

