/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.external;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.repository.authorization.oauth2.TokenStore;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointSearchConfiguration;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.SharepointCachingExtRepository;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.SharepointExtRepository;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.external.SharepointExtRepositoryAdapter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SharepointRepositoryFactoryProvider.class})
public class SharepointRepositoryFactoryProvider {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private RepositoryEntryLocalService _repositoryEntryLocalService;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private TokenStore _tokenStore;
    @Reference
    private UserLocalService _userLocalService;

    public SharepointRepositoryFactory createForConfiguration(SharepointRepositoryConfiguration sharepointRepositoryConfiguration, SharepointSearchConfiguration sharepointSearchConfiguration) {
        return new SharepointRepositoryFactory(sharepointRepositoryConfiguration, sharepointSearchConfiguration);
    }

    private class SharepointRepositoryFactory
    implements RepositoryFactory {
        private final SharepointRepositoryConfiguration _sharepointRepositoryConfiguration;
        private final SharepointSearchConfiguration _sharepointSearchConfiguration;

        public SharepointRepositoryFactory(SharepointRepositoryConfiguration sharepointRepositoryConfiguration, SharepointSearchConfiguration sharepointSearchConfiguration) {
            this._sharepointRepositoryConfiguration = sharepointRepositoryConfiguration;
            this._sharepointSearchConfiguration = sharepointSearchConfiguration;
        }

        public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
            BaseRepository baseRepository = this._createBaseRepository(repositoryId);
            return baseRepository.getLocalRepository();
        }

        public com.liferay.portal.kernel.repository.Repository createRepository(long repositoryId) throws PortalException {
            return this._createBaseRepository(repositoryId);
        }

        private BaseRepository _createBaseRepository(long repositoryId) throws PortalException {
            SharepointExtRepositoryAdapter sharepointExtRepositoryAdapter = new SharepointExtRepositoryAdapter(new SharepointCachingExtRepository(new SharepointExtRepository(SharepointRepositoryFactoryProvider.this._tokenStore, this._sharepointRepositoryConfiguration, this._sharepointSearchConfiguration)));
            sharepointExtRepositoryAdapter.setAssetEntryLocalService(SharepointRepositoryFactoryProvider.this._assetEntryLocalService);
            Repository repository = SharepointRepositoryFactoryProvider.this._repositoryLocalService.getRepository(repositoryId);
            sharepointExtRepositoryAdapter.setCompanyId(repository.getCompanyId());
            sharepointExtRepositoryAdapter.setCompanyLocalService(SharepointRepositoryFactoryProvider.this._companyLocalService);
            sharepointExtRepositoryAdapter.setDLAppHelperLocalService(SharepointRepositoryFactoryProvider.this._dlAppHelperLocalService);
            sharepointExtRepositoryAdapter.setDLFolderLocalService(SharepointRepositoryFactoryProvider.this._dlFolderLocalService);
            sharepointExtRepositoryAdapter.setGroupId(repository.getGroupId());
            sharepointExtRepositoryAdapter.setRepositoryId(repository.getRepositoryId());
            sharepointExtRepositoryAdapter.setRepositoryEntryLocalService(SharepointRepositoryFactoryProvider.this._repositoryEntryLocalService);
            sharepointExtRepositoryAdapter.setUserLocalService(SharepointRepositoryFactoryProvider.this._userLocalService);
            sharepointExtRepositoryAdapter.setTypeSettingsProperties(repository.getTypeSettingsProperties());
            sharepointExtRepositoryAdapter.initRepository();
            return sharepointExtRepositoryAdapter;
        }
    }
}

