/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.capability;

import com.liferay.document.library.repository.authorization.capability.AuthorizationCapability;
import com.liferay.document.library.repository.authorization.capability.AuthorizationException;
import com.liferay.document.library.repository.authorization.oauth2.OAuth2AuthorizationException;
import com.liferay.document.library.repository.authorization.oauth2.Token;
import com.liferay.document.library.repository.authorization.oauth2.TokenStore;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharepoint.rest.repository.internal.configuration.SharepointRepositoryConfiguration;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryRequestState;
import com.liferay.sharepoint.rest.repository.internal.document.library.repository.authorization.oauth2.SharepointRepositoryTokenBroker;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharepointRepositoryAuthorizationCapability
implements AuthorizationCapability {
    private final SharepointRepositoryTokenBroker _sharepointOAuth2AuthorizationServer;
    private final SharepointRepositoryConfiguration _sharepointRepositoryOAuth2Configuration;
    private final TokenStore _tokenStore;

    public SharepointRepositoryAuthorizationCapability(TokenStore tokenStore, SharepointRepositoryConfiguration sharepointRepositoryConfiguration, SharepointRepositoryTokenBroker sharepointOAuth2AuthorizationServer) {
        this._tokenStore = tokenStore;
        this._sharepointOAuth2AuthorizationServer = sharepointOAuth2AuthorizationServer;
        this._sharepointRepositoryOAuth2Configuration = sharepointRepositoryConfiguration;
    }

    public void authorize(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        this._authorize(PortalUtil.getOriginalServletRequest((HttpServletRequest)request), response);
    }

    public void authorize(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortalException {
        this.authorize(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), PortalUtil.getHttpServletResponse((PortletResponse)portletResponse));
    }

    public boolean hasCustomRedirectFlow(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, PortalException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        if (this._hasAuthorizationGrant(request)) {
            return true;
        }
        Token token = this._tokenStore.get(this._sharepointRepositoryOAuth2Configuration.name(), PortalUtil.getUserId((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest)));
        if (token == null) {
            return true;
        }
        if (token.isExpired()) {
            return !Validator.isNotNull((String)token.getRefreshToken());
        }
        return false;
    }

    private void _authorize(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        this._validateRequest(request);
        if (this._hasAuthorizationGrant(request)) {
            this._requestAccessToken(request, response);
        } else {
            Token token = this._tokenStore.get(this._sharepointRepositoryOAuth2Configuration.name(), PortalUtil.getUserId((HttpServletRequest)request));
            if (token == null) {
                this._requestAuthorizationGrant(request, response);
            } else if (token.isExpired()) {
                if (Validator.isNotNull((String)token.getRefreshToken())) {
                    this._refreshAccessToken(token, request);
                } else {
                    this._requestAccessToken(request, response);
                }
            }
        }
    }

    private String _getGrantURL(HttpServletRequest request, String state) {
        String url = this._sharepointRepositoryOAuth2Configuration.authorizationGrantEndpoint();
        url = HttpUtil.addParameter((String)url, (String)"client_id", (String)this._sharepointRepositoryOAuth2Configuration.clientId());
        url = HttpUtil.addParameter((String)url, (String)"redirect_uri", (String)this._getRedirectURI(request));
        url = HttpUtil.addParameter((String)url, (String)"response_type", (String)"code");
        url = HttpUtil.addParameter((String)url, (String)"scope", (String)this._sharepointRepositoryOAuth2Configuration.scope());
        url = HttpUtil.addParameter((String)url, (String)"state", (String)state);
        return url;
    }

    private String _getRedirectURI(HttpServletRequest request) {
        return PortalUtil.getAbsoluteURL((HttpServletRequest)request, (String)(PortalUtil.getPathMain() + "/document_library/sharepoint/oauth2"));
    }

    private boolean _hasAuthorizationGrant(HttpServletRequest request) {
        String code = ParamUtil.getString((HttpServletRequest)request, (String)"code");
        return !Validator.isNull((String)code);
    }

    private void _refreshAccessToken(Token token, HttpServletRequest request) throws IOException, PortalException {
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        try {
            Token freshToken = this._sharepointOAuth2AuthorizationServer.refreshAccessToken(token);
            this._tokenStore.save(this._sharepointRepositoryOAuth2Configuration.name(), userId, freshToken);
        }
        catch (AuthorizationException ae) {
            this._tokenStore.delete(this._sharepointRepositoryOAuth2Configuration.name(), userId);
            throw ae;
        }
    }

    private void _requestAccessToken(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        SharepointRepositoryRequestState sharepointRepositoryRequestState = SharepointRepositoryRequestState.get(request);
        sharepointRepositoryRequestState.validate(ParamUtil.getString((HttpServletRequest)request, (String)"state"));
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        String code = ParamUtil.getString((HttpServletRequest)request, (String)"code");
        Token accessToken = this._sharepointOAuth2AuthorizationServer.requestAccessToken(code, this._getRedirectURI(request));
        this._tokenStore.save(this._sharepointRepositoryOAuth2Configuration.name(), userId, accessToken);
        sharepointRepositoryRequestState.restore(request, response);
    }

    private void _requestAuthorizationGrant(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String state = StringUtil.randomString((int)5);
        SharepointRepositoryRequestState.save(request, state);
        response.sendRedirect(this._getGrantURL(request, state));
    }

    private void _validateRequest(HttpServletRequest request) throws AuthorizationException {
        String error = ParamUtil.getString((HttpServletRequest)request, (String)"error");
        if (Validator.isNotNull((String)error)) {
            String description = ParamUtil.getString((HttpServletRequest)request, (String)"error_description");
            if (Validator.isNull((String)description)) {
                description = error;
            }
            throw OAuth2AuthorizationException.getErrorException((String)error, (String)description);
        }
    }
}

