/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.sharepoint.connector.SharepointException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class QueryServiceSoapResult {
    private String _debugErrorMessage;
    private final DefaultHandler _defaultHandler = new DefaultHandler(){
        private final StringBuilder _sb = new StringBuilder();

        @Override
        public void characters(char[] chars, int start, int length) {
            this._sb.append(chars, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (localName.equals("DebugErrorMessage")) {
                QueryServiceSoapResult.this._setDebugErrorMessage(this._sb.toString());
            } else if (localName.equals("LinkUrl")) {
                QueryServiceSoapResult.this._linkURLs.add(this._sb.toString());
            } else if (localName.equals("Status")) {
                QueryServiceSoapResult.this._setStatus(this._sb.toString());
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this._sb.setLength(0);
        }
    };
    private final List<String> _linkURLs = new ArrayList<String>();
    private String _status;

    public QueryServiceSoapResult(String queryServiceSoapResultString) throws SharepointException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(this._defaultHandler);
            xmlReader.setErrorHandler(this._defaultHandler);
            this.parse(xmlReader, queryServiceSoapResultString);
        }
        catch (IOException ioe) {
            throw new SharepointException("Unable to parse response from the Sharepoint server", ioe);
        }
        catch (SAXException saxe) {
            throw new SharepointException("Unable to parse response from the Sharepoint server", saxe);
        }
    }

    public String getDebugErrorMessage() {
        return this._debugErrorMessage;
    }

    public List<String> getLinkURLs() {
        return this._linkURLs;
    }

    public String getStatus() {
        return this._status;
    }

    public boolean isEmpty() {
        return this.isSuccess() && this._status.equals("ERROR_NO_RESULTS_FOUND");
    }

    public boolean isSuccess() {
        return !this._status.equals("SUCCESS") && !this._status.equals("ERROR_NO_RESULTS_FOUND");
    }

    protected void parse(XMLReader xmlReader, String queryServiceSoapResultString) throws IOException, SAXException {
        byte[] bytes = queryServiceSoapResultString.getBytes("UTF-8");
        xmlReader.parse(new InputSource(new ByteArrayInputStream(bytes)));
    }

    private void _setDebugErrorMessage(String debugErrorMessage) {
        this._debugErrorMessage = debugErrorMessage;
    }

    private void _setStatus(String status) {
        this._status = status;
    }
}

