/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.SharepointVersion;
import com.liferay.sharepoint.connector.internal.util.RemoteExceptionUtil;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.connector.operation.SharepointVersionComparator;
import com.microsoft.schemas.sharepoint.soap.GetVersionsResponseGetVersionsResult;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.axis.encoding.AnyContentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetSharepointVersionsOperation
extends BaseOperation {
    private static final Comparator<SharepointVersion> _comparator = new SharepointVersionComparator();
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;

    @Override
    public void afterPropertiesSet() {
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
    }

    public List<SharepointVersion> execute(String filePath) throws SharepointException {
        try {
            SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(filePath);
            if (sharepointObject == null) {
                throw new SharepointException("Unable to find Sharepoint object at " + filePath);
            }
            String fileFullPath = this.toFullPath(filePath);
            GetVersionsResponseGetVersionsResult getVersionsResponseGetVersionsResult = this.versionsSoap.getVersions(fileFullPath);
            Element getVersionsResponseGetVersionsResultElement = xmlHelper.getElement((AnyContentType)getVersionsResponseGetVersionsResult);
            return this.getSharepointVersions(sharepointObject.getSharepointObjectId(), getVersionsResponseGetVersionsResultElement);
        }
        catch (RemoteException re) {
            RemoteExceptionUtil.handleRemoteException(re);
            throw new IllegalStateException();
        }
    }

    protected Date getDate(String dateString) {
        Calendar calendar = DatatypeConverter.parseDateTime((String)dateString);
        return calendar.getTime();
    }

    protected String getSharepointVersionId(long sharepointObjectId, String version) {
        return sharepointObjectId + "@" + version;
    }

    protected List<SharepointVersion> getSharepointVersions(long sharepointObjectId, Element getVersionsResponseGetVersionsResultElement) {
        ArrayList<SharepointVersion> sharepointVersions = new ArrayList<SharepointVersion>();
        NodeList nodeList = getVersionsResponseGetVersionsResultElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String localName = node.getLocalName();
            if (localName == null || !StringUtil.equalsIgnoreCase((String)localName, (String)"result")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node commentsNode = namedNodeMap.getNamedItem("comments");
            Node createdByNode = namedNodeMap.getNamedItem("createdBy");
            Node createdRawNode = namedNodeMap.getNamedItem("createdRaw");
            Node versionNode = namedNodeMap.getNamedItem("version");
            Node urlNode = namedNodeMap.getNamedItem("url");
            Node sizeNode = namedNodeMap.getNamedItem("size");
            SharepointVersion sharepointVersion = new SharepointVersion(commentsNode.getNodeValue(), createdByNode.getNodeValue(), this.getDate(createdRawNode.getNodeValue()), this.getSharepointVersionId(sharepointObjectId, versionNode.getNodeValue()), GetterUtil.getLong((String)sizeNode.getNodeValue()), urlHelper.toURL(urlNode.getNodeValue()), this.getVersion(versionNode.getNodeValue()));
            sharepointVersions.add(sharepointVersion);
        }
        Collections.sort(sharepointVersions, _comparator);
        return sharepointVersions;
    }

    protected String getVersion(String version) {
        if (version.startsWith("@")) {
            version = version.substring(1);
        }
        return version;
    }
}

