/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.sharepoint.connector.SharepointConnectionInfo;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.operation.Operation;
import com.liferay.sharepoint.connector.operation.PathHelper;
import com.liferay.sharepoint.connector.operation.URLHelper;
import com.liferay.sharepoint.connector.schema.XMLHelper;
import com.microsoft.schemas.sharepoint.soap.CopySoap;
import com.microsoft.schemas.sharepoint.soap.ListsSoap;
import com.microsoft.schemas.sharepoint.soap.VersionsSoap;
import java.net.URL;
import java.util.List;
import java.util.Map;

public abstract class BaseOperation
implements Operation {
    protected static PathHelper pathHelper = new PathHelper();
    protected static URLHelper urlHelper = new URLHelper();
    protected static XMLHelper xmlHelper = new XMLHelper();
    protected CopySoap copySoap;
    protected ListsSoap listsSoap;
    protected SharepointConnectionInfo sharepointConnectionInfo;
    protected VersionsSoap versionsSoap;
    private Map<Class<?>, Operation> _operations;

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public void setCopySoap(CopySoap copySoap) {
        this.copySoap = copySoap;
    }

    @Override
    public void setListsSoap(ListsSoap listsSoap) {
        this.listsSoap = listsSoap;
    }

    @Override
    public void setOperations(Map<Class<?>, Operation> operations) {
        this._operations = operations;
    }

    @Override
    public void setSharepointConnectionInfo(SharepointConnectionInfo sharepointConnectionInfo) {
        this.sharepointConnectionInfo = sharepointConnectionInfo;
    }

    @Override
    public void setVersionsSoap(VersionsSoap versionsSoap) {
        this.versionsSoap = versionsSoap;
    }

    public URL toURL(String path) {
        pathHelper.validatePath(path);
        URL serviceURL = this.sharepointConnectionInfo.getServiceURL();
        return urlHelper.toURL(serviceURL.toString() + this.sharepointConnectionInfo.getLibraryPath() + path);
    }

    protected <O extends Operation> O getOperation(Class<O> clazz) {
        return (O)this._operations.get(clazz);
    }

    protected SharepointObject getSharepointObject(List<SharepointObject> sharepointObjects) {
        if (sharepointObjects.isEmpty()) {
            return null;
        }
        return sharepointObjects.get(0);
    }

    protected String toFullPath(String path) {
        pathHelper.validatePath(path);
        StringBundler sb = new StringBundler(4);
        sb.append(this.sharepointConnectionInfo.getSitePath());
        sb.append("/");
        sb.append(this.sharepointConnectionInfo.getLibraryPath());
        if (!path.equals("/")) {
            sb.append(path);
        }
        return sb.toString();
    }
}

