/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector;

import com.liferay.portal.kernel.util.StringBundler;
import java.net.URL;
import java.util.Date;
import java.util.Set;

public class SharepointObject {
    private final String _author;
    private final String _checkedOutBy;
    private final Date _createdDate;
    private final String _extension;
    private final boolean _folder;
    private final String _folderPath;
    private final Date _lastModifiedDate;
    private final String _name;
    private final String _path;
    private final Set<Permission> _permissions;
    private final long _sharepointObjectId;
    private final long _size;
    private final URL _url;

    public SharepointObject(String author, String checkedOutBy, Date createdDate, boolean folder, Date lastModifiedDate, String path, Set<Permission> permissions, long sharepointObjectId, long size, URL url) {
        this._author = author;
        this._checkedOutBy = checkedOutBy;
        this._createdDate = createdDate;
        this._folder = folder;
        this._lastModifiedDate = lastModifiedDate;
        this._path = path;
        this._permissions = permissions;
        this._sharepointObjectId = sharepointObjectId;
        this._size = size;
        this._url = url;
        this._extension = this._getExtension(path);
        this._folderPath = this._getFolderPath(path);
        this._name = this._getName(path);
    }

    public String getAuthor() {
        return this._author;
    }

    public String getCheckedOutBy() {
        return this._checkedOutBy;
    }

    public Date getCreatedDate() {
        return this._createdDate;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getFolderPath() {
        return this._folderPath;
    }

    public Date getLastModifiedDate() {
        return this._lastModifiedDate;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public Set<Permission> getPermissions() {
        return this._permissions;
    }

    public long getSharepointObjectId() {
        return this._sharepointObjectId;
    }

    public long getSize() {
        return this._size;
    }

    public URL getURL() {
        return this._url;
    }

    public boolean isFile() {
        return !this.isFolder();
    }

    public boolean isFolder() {
        return this._folder;
    }

    public String toString() {
        StringBundler sb = new StringBundler(27);
        sb.append("{_author=");
        sb.append(this._author);
        sb.append(", checkedOutBy=");
        sb.append(this._checkedOutBy);
        sb.append(", createdDate=");
        sb.append((Object)this._createdDate);
        sb.append(", extension=");
        sb.append(this._extension);
        sb.append(", folderPath=");
        sb.append(this._folderPath);
        sb.append(", folder=");
        sb.append(this._folder);
        sb.append(", lastModifiedDate=");
        sb.append((Object)this._lastModifiedDate);
        sb.append(", name=");
        sb.append(this._name);
        sb.append(", path=");
        sb.append(this._path);
        sb.append(", permissions=");
        sb.append(this._permissions);
        sb.append(", sharepointObjectId=");
        sb.append(this._sharepointObjectId);
        sb.append(", size=");
        sb.append(this._size);
        sb.append(", url=");
        sb.append((Object)this._url);
        sb.append("}");
        return sb.toString();
    }

    private String _getExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return path.substring(index + 1);
    }

    private String _getFolderPath(String path) {
        int index = path.lastIndexOf("/");
        if (index == 0) {
            return "/";
        }
        return path.substring(0, index);
    }

    private String _getName(String path) {
        if (path.equals("/")) {
            return "/";
        }
        int index = path.lastIndexOf("/");
        return path.substring(index + 1);
    }

    public static enum Permission {
        ADD_AND_CUSTOMIZE_PAGES(262144L),
        ADD_DEL_PRIVATE_WEB_PARTS(0x10000000L),
        ADD_LIST_ITEMS(2L),
        APPLY_STYLE_SHEETS(0x100000L),
        APPLY_THEME_AND_BORDER(524288L),
        APPROVE_ITEMS(16L),
        BROWSE_DIRECTORIES(0x4000000L),
        BROWSE_USER_INFO(0x8000000L),
        CANCEL_CHECKOUT(256L),
        CREATE_ALERTS(0x8000000000L),
        CREATE_GROUPS(0x1000000L),
        CREATE_SSC_SITE(0x400000L),
        DELETE_LIST_ITEMS(8L),
        DELETE_VERSIONS(128L),
        EDIT_LIST_ITEMS(4L),
        EDIT_MY_USER_INFO(0x10000000000L),
        ENUMERATE_PERMISSIONS(0x4000000000000000L),
        MANAGE_ALERTS(0x4000000000L),
        MANAGE_LISTS(2048L),
        MANAGE_PERMISSIONS(0x2000000L),
        MANAGE_PERSONAL_VIEWS(512L),
        MANAGE_SUBWEBS(0x800000L),
        MANAGE_WEB(0x40000000L),
        OPEN(65536L),
        OPEN_ITEMS(32L),
        UPDATE_PERSONAL_WEB_PARTS(0x20000000L),
        USE_CLIENT_INTEGRATION(0x1000000000L),
        USE_REMOTE_APIS(0x2000000000L),
        VIEW_FORM_PAGES(4096L),
        VIEW_LIST_ITEMS(1L),
        VIEW_PAGES(131072L),
        VIEW_USAGE_DATA(0x200000L),
        VIEW_VERSIONS(64L);

        private final long _mask;

        public long getMask() {
            return this._mask;
        }

        private Permission(long mask) {
            this._mask = mask;
        }
    }
}

