/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.sharepoint.connector.SharepointConnection;
import com.liferay.sharepoint.connector.SharepointConnectionInfo;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.SharepointRuntimeException;
import com.liferay.sharepoint.connector.SharepointVersion;
import com.liferay.sharepoint.connector.operation.AddFolderOperation;
import com.liferay.sharepoint.connector.operation.AddOrUpdateFileOperation;
import com.liferay.sharepoint.connector.operation.BatchOperation;
import com.liferay.sharepoint.connector.operation.CancelCheckOutFileOperation;
import com.liferay.sharepoint.connector.operation.CheckInFileOperation;
import com.liferay.sharepoint.connector.operation.CheckOutFileOperation;
import com.liferay.sharepoint.connector.operation.CopySharepointObjectOperation;
import com.liferay.sharepoint.connector.operation.DeleteSharepointObjectOperation;
import com.liferay.sharepoint.connector.operation.GetInputStreamOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectByIdOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectsByFolderOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectsByNameOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectsByQueryOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointVersionsOperation;
import com.liferay.sharepoint.connector.operation.MoveSharepointObjectOperation;
import com.liferay.sharepoint.connector.operation.Operation;
import com.liferay.sharepoint.connector.operation.PathHelper;
import com.liferay.sharepoint.connector.operation.URLHelper;
import com.liferay.sharepoint.connector.schema.query.Query;
import com.liferay.sharepoint.connector.schema.query.QueryOptionsList;
import com.microsoft.schemas.sharepoint.soap.CopyLocator;
import com.microsoft.schemas.sharepoint.soap.CopySoap;
import com.microsoft.schemas.sharepoint.soap.ListsLocator;
import com.microsoft.schemas.sharepoint.soap.ListsSoap;
import com.microsoft.schemas.sharepoint.soap.VersionsLocator;
import com.microsoft.schemas.sharepoint.soap.VersionsSoap;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;

public class SharepointConnectionImpl
implements SharepointConnection {
    public static final long SHAREPOINT_ROOT_FOLDER_SHAREPOINT_OBJECT_ID = -1L;
    private static final PathHelper _pathHelper = new PathHelper();
    private static final URLHelper _urlHelper = new URLHelper();
    private AddFolderOperation _addFolderOperation;
    private AddOrUpdateFileOperation _addOrUpdateFileOperation;
    private BatchOperation _batchOperation;
    private CancelCheckOutFileOperation _cancelCheckOutFileOperation;
    private CheckInFileOperation _checkInFileOperation;
    private CheckOutFileOperation _checkOutFileOperation;
    private CopySharepointObjectOperation _copySharepointObjectOperation;
    private CopySoap _copySoap;
    private DeleteSharepointObjectOperation _deleteSharepointObjectOperation;
    private GetInputStreamOperation _getInputStreamOperation;
    private GetSharepointObjectByIdOperation _getSharepointObjectByIdOperation;
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;
    private GetSharepointObjectsByFolderOperation _getSharepointObjectsByFolderOperation;
    private GetSharepointObjectsByNameOperation _getSharepointObjectsByNameOperation;
    private GetSharepointObjectsByQueryOperation _getSharepointObjectsByQueryOperation;
    private GetSharepointVersionsOperation _getSharepointVersionsOperation;
    private ListsSoap _listsSoap;
    private MoveSharepointObjectOperation _moveSharepointObjectOperation;
    private final Map<Class<?>, Operation> _operations = new HashMap();
    private final SharepointConnectionInfo _sharepointConnectionInfo;
    private SharepointObject _sharepointRootFolder;
    private VersionsSoap _versionsSoap;

    public SharepointConnectionImpl(SharepointConnection.ServerVersion serverVersion, String serverProtocol, String serverAddress, int serverPort, String sitePath, String libraryName, String libraryPath, String username, String password) throws SharepointRuntimeException {
        this._sharepointConnectionInfo = new SharepointConnectionInfo(serverVersion, serverProtocol, serverAddress, serverPort, sitePath, libraryName, libraryPath, username, password);
        this.initCopySoap();
        this.initListsSoap();
        this.initSharepointRootFolder();
        this.initVersionsSoap();
        this.buildOperations();
    }

    @Override
    public void addFile(String folderPath, String fileName, String changeLog, InputStream inputStream) throws SharepointException {
        String filePath = _pathHelper.buildPath(folderPath, fileName);
        changeLog = GetterUtil.getString((String)changeLog);
        this._addOrUpdateFileOperation.execute(filePath, changeLog, inputStream);
    }

    @Override
    public void addFolder(String folderPath, String folderName) throws SharepointException {
        _pathHelper.validatePath(folderPath);
        _pathHelper.validateName(folderName);
        this._addFolderOperation.execute(folderPath, folderName);
    }

    @Override
    public boolean cancelCheckOutFile(String filePath) throws SharepointException {
        _pathHelper.validatePath(filePath);
        return this._cancelCheckOutFileOperation.execute(filePath);
    }

    @Override
    public boolean checkInFile(String filePath, String comment, SharepointConnection.CheckInType checkInType) throws SharepointException {
        _pathHelper.validatePath(filePath);
        return this._checkInFileOperation.execute(filePath, comment, checkInType);
    }

    @Override
    public boolean checkOutFile(String filePath) throws SharepointException {
        _pathHelper.validatePath(filePath);
        return this._checkOutFileOperation.execute(filePath);
    }

    @Override
    public void copySharepointObject(String path, String newPath) throws SharepointException {
        _pathHelper.validatePath(path);
        _pathHelper.validatePath(newPath);
        this._copySharepointObjectOperation.execute(path, newPath);
    }

    @Override
    public void deleteSharepointObject(String path) throws SharepointException {
        _pathHelper.validatePath(path);
        this._deleteSharepointObjectOperation.execute(path);
    }

    @Override
    public InputStream getInputStream(SharepointObject sharepointObject) throws SharepointException {
        return this._getInputStreamOperation.execute(sharepointObject);
    }

    @Override
    public InputStream getInputStream(SharepointVersion sharepointVersion) throws SharepointException {
        return this._getInputStreamOperation.execute(sharepointVersion);
    }

    @Override
    public SharepointConnectionInfo getSharepointConnectionInfo() {
        return this._sharepointConnectionInfo;
    }

    @Override
    public SharepointObject getSharepointObject(long sharepointObjectId) throws SharepointException {
        if (sharepointObjectId == -1L) {
            return this._sharepointRootFolder;
        }
        return this._getSharepointObjectByIdOperation.execute(sharepointObjectId);
    }

    @Override
    public SharepointObject getSharepointObject(String path) throws SharepointException {
        _pathHelper.validatePath(path);
        if (path.equals("/")) {
            return this._sharepointRootFolder;
        }
        return this._getSharepointObjectByPathOperation.execute(path);
    }

    @Override
    public List<SharepointObject> getSharepointObjects(Query query, QueryOptionsList queryOptionsList) throws SharepointException {
        return this._getSharepointObjectsByQueryOperation.execute(query, queryOptionsList, new String[0]);
    }

    @Override
    public List<SharepointObject> getSharepointObjects(String name) throws SharepointException {
        return this._getSharepointObjectsByNameOperation.execute(name);
    }

    @Override
    public List<SharepointObject> getSharepointObjects(String folderPath, SharepointConnection.ObjectTypeFilter objectTypeFilter) throws SharepointException {
        _pathHelper.validatePath(folderPath);
        return this._getSharepointObjectsByFolderOperation.execute(folderPath, objectTypeFilter);
    }

    @Override
    public int getSharepointObjectsCount(String folderPath, SharepointConnection.ObjectTypeFilter objectTypeFilter) throws SharepointException {
        List<SharepointObject> sharepointObjects = this.getSharepointObjects(folderPath, objectTypeFilter);
        return sharepointObjects.size();
    }

    @Override
    public List<SharepointVersion> getSharepointVersions(String filePath) throws SharepointException {
        _pathHelper.validatePath(filePath);
        return this._getSharepointVersionsOperation.execute(filePath);
    }

    public void initSharepointRootFolder() {
        URL serviceURL = this._sharepointConnectionInfo.getServiceURL();
        String libraryPath = this._sharepointConnectionInfo.getLibraryPath();
        URL libraryURL = _urlHelper.toURL(serviceURL + libraryPath);
        this._sharepointRootFolder = new SharepointObject("", null, new Date(0L), true, new Date(0L), "/", EnumSet.allOf(SharepointObject.Permission.class), -1L, 0L, libraryURL);
    }

    @Override
    public void moveSharepointObject(String path, String newPath) throws SharepointException {
        _pathHelper.validatePath(path);
        _pathHelper.validatePath(newPath);
        this._moveSharepointObjectOperation.execute(path, newPath);
    }

    @Override
    public void updateFile(String filePath, InputStream inputStream) throws SharepointException {
        _pathHelper.validatePath(filePath);
        this._addOrUpdateFileOperation.execute(filePath, null, inputStream);
    }

    protected <O extends Operation> O buildOperation(Class<O> clazz) {
        try {
            Operation operation = (Operation)clazz.newInstance();
            operation.setCopySoap(this._copySoap);
            operation.setListsSoap(this._listsSoap);
            operation.setOperations(this._operations);
            operation.setSharepointConnectionInfo(this._sharepointConnectionInfo);
            operation.setVersionsSoap(this._versionsSoap);
            this._operations.put(clazz, operation);
            return (O)operation;
        }
        catch (Exception e) {
            throw new SharepointRuntimeException("Unable to initialize operation " + clazz.getName(), e);
        }
    }

    protected void buildOperations() {
        this._addFolderOperation = this.buildOperation(AddFolderOperation.class);
        this._addOrUpdateFileOperation = this.buildOperation(AddOrUpdateFileOperation.class);
        this._batchOperation = this.buildOperation(BatchOperation.class);
        this._cancelCheckOutFileOperation = this.buildOperation(CancelCheckOutFileOperation.class);
        this._checkInFileOperation = this.buildOperation(CheckInFileOperation.class);
        this._checkOutFileOperation = this.buildOperation(CheckOutFileOperation.class);
        this._copySharepointObjectOperation = this.buildOperation(CopySharepointObjectOperation.class);
        this._deleteSharepointObjectOperation = this.buildOperation(DeleteSharepointObjectOperation.class);
        this._getInputStreamOperation = this.buildOperation(GetInputStreamOperation.class);
        this._getSharepointObjectByIdOperation = this.buildOperation(GetSharepointObjectByIdOperation.class);
        this._getSharepointObjectByPathOperation = this.buildOperation(GetSharepointObjectByPathOperation.class);
        this._getSharepointObjectsByFolderOperation = this.buildOperation(GetSharepointObjectsByFolderOperation.class);
        this._getSharepointObjectsByNameOperation = this.buildOperation(GetSharepointObjectsByNameOperation.class);
        this._getSharepointObjectsByQueryOperation = this.buildOperation(GetSharepointObjectsByQueryOperation.class);
        this._getSharepointVersionsOperation = this.buildOperation(GetSharepointVersionsOperation.class);
        this._moveSharepointObjectOperation = this.buildOperation(MoveSharepointObjectOperation.class);
        Set<Map.Entry<Class<?>, Operation>> set = this._operations.entrySet();
        for (Map.Entry<Class<?>, Operation> entry : set) {
            Operation operation = entry.getValue();
            operation.afterPropertiesSet();
        }
    }

    protected void configureStub(Stub stub, URL serviceURL) {
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)serviceURL.toString());
        stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this._sharepointConnectionInfo.getPassword());
        stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this._sharepointConnectionInfo.getUsername());
    }

    protected URL getServiceURL(String serviceName) {
        URL url = this._sharepointConnectionInfo.getServiceURL();
        return _urlHelper.toURL(StringBundler.concat((Object[])new Object[]{url, "_vti_bin/", serviceName, ".asmx"}));
    }

    protected URL getWSDLURL(String serviceName) {
        String name = "/wsdl/" + serviceName + ".wsdl";
        try {
            Class<?> clazz = this.getClass();
            URL url = clazz.getResource(name);
            return new URL(url.toExternalForm());
        }
        catch (MalformedURLException murle) {
            throw new SharepointRuntimeException("Unable to load WSDL " + name, murle);
        }
    }

    protected void initCopySoap() {
        URL wsdlURL = this.getWSDLURL("copy");
        URL serviceURL = this.getServiceURL("copy");
        try {
            CopyLocator copyLocator = new CopyLocator();
            this._copySoap = copyLocator.getCopySoap(wsdlURL);
            this.configureStub((Stub)this._copySoap, serviceURL);
        }
        catch (ServiceException se) {
            throw new SharepointRuntimeException("Unable to configure SOAP endpoint " + wsdlURL, se);
        }
    }

    protected void initListsSoap() {
        URL wsdlURL = this.getWSDLURL("lists");
        URL serviceURL = this.getServiceURL("lists");
        try {
            ListsLocator listsLocator = new ListsLocator();
            this._listsSoap = listsLocator.getListsSoap(wsdlURL);
            this.configureStub((Stub)this._listsSoap, serviceURL);
        }
        catch (ServiceException se) {
            throw new SharepointRuntimeException("Unable to configure SOAP endpoint " + wsdlURL, se);
        }
    }

    protected void initVersionsSoap() {
        URL wsdlURL = this.getWSDLURL("versions");
        URL serviceURL = this.getServiceURL("versions");
        try {
            VersionsLocator versionsLocator = new VersionsLocator();
            this._versionsSoap = versionsLocator.getVersionsSoap(wsdlURL);
            this.configureStub((Stub)this._versionsSoap, serviceURL);
        }
        catch (ServiceException se) {
            throw new SharepointRuntimeException("Unable to configure SOAP endpoint " + wsdlURL, se);
        }
    }
}

