/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.server.manager.internal.executor.BaseExecutor;
import com.liferay.server.manager.internal.executor.Executor;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"server.manager.executor.path=/server/debug-port"}, service={Executor.class})
public class DebugPortExecutor
extends BaseExecutor {
    private static final Pattern _pattern = Pattern.compile("address=(\\d+)");

    @Override
    public void executeRead(HttpServletRequest httpServletRequest, JSONObject responseJSONObject, Queue<String> arguments) {
        String debugPort = this.getDebugPort();
        if (debugPort == null) {
            responseJSONObject.put("error", "Server was not started in debug mode").put("status", 1);
        } else {
            responseJSONObject.put("output", debugPort);
        }
    }

    protected String getDebugPort() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        if (inputArguments == null) {
            return null;
        }
        for (String inputArgument : inputArguments) {
            Matcher matcher;
            if (!inputArgument.contains("transport=dt_socket") || !(matcher = _pattern.matcher(inputArgument)).find()) continue;
            return matcher.group(1);
        }
        return null;
    }
}

