/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.base.SegmentsExperienceServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=segments", "json.web.service.context.path=SegmentsExperience"}, service={AopService.class})
public class SegmentsExperienceServiceImpl
extends SegmentsExperienceServiceBaseImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPermission _layoutPermission;
    @Reference(target="(resource.name=com.liferay.segments)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(target="(model.class.name=com.liferay.segments.model.SegmentsExperience)")
    private ModelResourcePermission<SegmentsExperience> _segmentsExperienceResourcePermission;

    public SegmentsExperience addSegmentsExperience(String externalReferenceCode, long groupId, long segmentsEntryId, long plid, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        if (!this._hasUpdateLayoutPermission(this._getPublishedLayoutPlid(plid))) {
            this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        }
        return this.segmentsExperienceLocalService.addSegmentsExperience(externalReferenceCode, this.getUserId(), groupId, segmentsEntryId, plid, nameMap, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public SegmentsExperience appendSegmentsExperience(long groupId, long segmentsEntryId, long plid, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        return this.appendSegmentsExperience(groupId, segmentsEntryId, plid, nameMap, active, new UnicodeProperties(true), serviceContext);
    }

    public SegmentsExperience appendSegmentsExperience(long groupId, long segmentsEntryId, long plid, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        if (!this._hasUpdateLayoutPermission(this._getPublishedLayoutPlid(plid))) {
            this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_SEGMENTS_ENTRIES");
        }
        return this.segmentsExperienceLocalService.appendSegmentsExperience(this.getUserId(), groupId, segmentsEntryId, plid, nameMap, active, typeSettingsUnicodeProperties, serviceContext);
    }

    public SegmentsExperience deleteSegmentsExperience(long segmentsExperienceId) throws PortalException {
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId), "DELETE");
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperienceId);
    }

    public SegmentsExperience deleteSegmentsExperience(String externalReferenceCode, long groupId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperienceByExternalReferenceCode(externalReferenceCode, groupId);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "DELETE");
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
    }

    public SegmentsExperience fetchSegmentsExperience(long groupId, String segmentsExperienceKey, long plid) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(groupId, segmentsExperienceKey, plid);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public SegmentsExperience getSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public SegmentsExperience getSegmentsExperience(long groupId, String segmentsExperienceKey, long plid) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperience(groupId, segmentsExperienceKey, this._getPublishedLayoutPlid(plid));
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public SegmentsExperience getSegmentsExperienceByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperienceLocalService.getSegmentsExperienceByExternalReferenceCode(externalReferenceCode, groupId);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "VIEW");
        return segmentsExperience;
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long plid, boolean active) throws PortalException {
        long publishedLayoutPlid = this._getPublishedLayoutPlid(plid);
        if (this._hasUpdateLayoutPermission(publishedLayoutPlid)) {
            return this.segmentsExperiencePersistence.findByG_P_A(groupId, publishedLayoutPlid, active);
        }
        return this.segmentsExperiencePersistence.filterFindByG_P_A(groupId, publishedLayoutPlid, active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long plid, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) throws PortalException {
        long publishedLayoutPlid = this._getPublishedLayoutPlid(plid);
        if (this._hasUpdateLayoutPermission(publishedLayoutPlid)) {
            return this.segmentsExperiencePersistence.findByG_P_A(groupId, publishedLayoutPlid, active, start, end, orderByComparator);
        }
        return this.segmentsExperiencePersistence.filterFindByG_P_A(groupId, publishedLayoutPlid, active, start, end, orderByComparator);
    }

    public int getSegmentsExperiencesCount(long groupId, long plid, boolean active) throws PortalException {
        long publishedLayoutPlid = this._getPublishedLayoutPlid(plid);
        if (this._hasUpdateLayoutPermission(publishedLayoutPlid)) {
            return this.segmentsExperiencePersistence.countByG_P_A(groupId, publishedLayoutPlid, active);
        }
        return this.segmentsExperiencePersistence.filterCountByG_P_A(groupId, publishedLayoutPlid, active);
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.getSegmentsExperience(segmentsExperienceId);
        return this.updateSegmentsExperience(segmentsExperienceId, segmentsEntryId, nameMap, active, segmentsExperience.getTypeSettingsUnicodeProperties());
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.segmentsExperienceLocalService.getSegmentsExperience(segmentsExperienceId), "UPDATE");
        return this.segmentsExperienceLocalService.updateSegmentsExperience(segmentsExperienceId, segmentsEntryId, nameMap, active, typeSettingsUnicodeProperties);
    }

    public void updateSegmentsExperiencePriority(long segmentsExperienceId, int newPriority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)segmentsExperience, "UPDATE");
        SegmentsExperience swapSegmentsExperience = this.segmentsExperiencePersistence.fetchByG_P_P(segmentsExperience.getGroupId(), segmentsExperience.getPlid(), newPriority);
        if (swapSegmentsExperience != null) {
            this._segmentsExperienceResourcePermission.check(this.getPermissionChecker(), (ClassedModel)swapSegmentsExperience, "UPDATE");
        }
        this.segmentsExperienceLocalService.updateSegmentsExperiencePriority(segmentsExperienceId, newPriority);
    }

    private long _getPublishedLayoutPlid(long plid) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout != null && layout.isDraftLayout()) {
            return layout.getClassPK();
        }
        return plid;
    }

    private boolean _hasUpdateLayoutPermission(long plid) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return false;
        }
        return this._layoutPermission.containsLayoutRestrictedUpdatePermission(this.getPermissionChecker(), layout);
    }
}

