/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.service.base.SegmentsEntryRoleLocalServiceBaseImpl;
import com.liferay.segments.service.persistence.SegmentsEntryPersistence;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsEntryRole"}, service={AopService.class})
public class SegmentsEntryRoleLocalServiceImpl
extends SegmentsEntryRoleLocalServiceBaseImpl {
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsEntryPersistence _segmentsEntryPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public SegmentsEntryRole addSegmentsEntryRole(long segmentsEntryId, long roleId, ServiceContext serviceContext) throws PortalException {
        this._roleLocalService.getRole(roleId);
        this._segmentsEntryPersistence.findByPrimaryKey(segmentsEntryId);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        long segmentsEntryRoleId = this.counterLocalService.increment();
        SegmentsEntryRole segmentsEntryRole = this.segmentsEntryRolePersistence.create(segmentsEntryRoleId);
        segmentsEntryRole.setCompanyId(user.getCompanyId());
        segmentsEntryRole.setUserId(user.getUserId());
        segmentsEntryRole.setUserName(user.getFullName());
        segmentsEntryRole.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsEntryRole.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntryRole.setSegmentsEntryId(segmentsEntryId);
        segmentsEntryRole.setRoleId(roleId);
        segmentsEntryRole = (SegmentsEntryRole)this.segmentsEntryRolePersistence.update((BaseModel)segmentsEntryRole);
        this._reindex(segmentsEntryId);
        return segmentsEntryRole;
    }

    @SystemEvent(type=1)
    public SegmentsEntryRole deleteSegmentsEntryRole(long segmentsEntryId, long roleId) throws PortalException {
        SegmentsEntryRole segmentsEntryRole = this.segmentsEntryRolePersistence.removeByS_R(segmentsEntryId, roleId);
        this._reindex(segmentsEntryId);
        return segmentsEntryRole;
    }

    @SystemEvent(type=1)
    public void deleteSegmentsEntryRoles(long segmentsEntryId) throws PortalException {
        this.segmentsEntryRolePersistence.removeBySegmentsEntryId(segmentsEntryId);
        this._reindex(segmentsEntryId);
    }

    @SystemEvent(type=1)
    public void deleteSegmentsEntryRolesByRoleId(long roleId) throws PortalException {
        List segmentsEntryRoles = this.segmentsEntryRolePersistence.findByRoleId(roleId);
        this.segmentsEntryRolePersistence.removeByRoleId(roleId);
        for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
            this._reindex(segmentsEntryRole.getSegmentsEntryId());
        }
    }

    public List<SegmentsEntryRole> getSegmentsEntryRoles(long segmentsEntryId) {
        return this.segmentsEntryRolePersistence.findBySegmentsEntryId(segmentsEntryId);
    }

    public List<SegmentsEntryRole> getSegmentsEntryRolesByRoleId(long roleId) {
        return this.segmentsEntryRolePersistence.findByRoleId(roleId);
    }

    public int getSegmentsEntryRolesCount(long segmentsEntryId) {
        return this.segmentsEntryRolePersistence.countBySegmentsEntryId(segmentsEntryId);
    }

    public int getSegmentsEntryRolesCountByRoleId(long roleId) {
        return this.segmentsEntryRolePersistence.countByRoleId(roleId);
    }

    public boolean hasSegmentEntryRole(long segmentsEntryId, long roleId) {
        return this.segmentsEntryRolePersistence.fetchByS_R(segmentsEntryId, roleId) != null;
    }

    public void setSegmentsEntrySiteRoles(long segmentsEntryId, long[] siteRoleIds, ServiceContext serviceContext) throws PortalException {
        Set newSiteRoleIdsSet = SetUtil.fromArray((long[])siteRoleIds);
        Set<Long> oldSiteRoleIdsSet = this._getSiteRoleIdsSet(segmentsEntryId);
        HashSet<Long> removeSiteRoleIdsSet = new HashSet<Long>(oldSiteRoleIdsSet);
        removeSiteRoleIdsSet.removeAll(newSiteRoleIdsSet);
        this._removeSiteRoles(segmentsEntryId, removeSiteRoleIdsSet);
        newSiteRoleIdsSet.removeAll(oldSiteRoleIdsSet);
        this._addSiteRoles(segmentsEntryId, newSiteRoleIdsSet, serviceContext);
    }

    private void _addSiteRoles(long segmentsEntryId, Set<Long> siteRoleIdsSet, ServiceContext serviceContext) throws PortalException {
        for (long siteRoleId : siteRoleIdsSet) {
            this.segmentsEntryRoleLocalService.addSegmentsEntryRole(segmentsEntryId, siteRoleId, serviceContext);
        }
    }

    private Set<Long> _getSiteRoleIdsSet(long segmentsEntryId) {
        HashSet<Long> roleIds = new HashSet<Long>();
        List<SegmentsEntryRole> segmentsEntryRoles = this.getSegmentsEntryRoles(segmentsEntryId);
        for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
            Role role = this._roleLocalService.fetchRole(segmentsEntryRole.getRoleId());
            if (!Objects.equals(role.getType(), 2)) continue;
            roleIds.add(role.getRoleId());
        }
        return roleIds;
    }

    private void _reindex(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryPersistence.fetchByPrimaryKey(segmentsEntryId);
        if (segmentsEntry == null) {
            return;
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(SegmentsEntry.class);
        indexer.reindex((Object)segmentsEntry);
    }

    private void _removeSiteRoles(long segmentsEntryId, Set<Long> siteRoleIdsSet) throws PortalException {
        for (long siteRoleId : siteRoleIdsSet) {
            this.segmentsEntryRoleLocalService.deleteSegmentsEntryRole(segmentsEntryId, siteRoleId);
        }
    }
}

