/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.scheduler;

import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={SchedulerJobConfiguration.class})
public class SegmentsEntryRelIndexerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private MessageBus _messageBus;
    private volatile SegmentsConfiguration _segmentsConfiguration;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            ActionableDynamicQuery actionableDynamicQuery = this._segmentsEntryLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property activeProperty = PropertyFactoryUtil.forName((String)"active");
                dynamicQuery.add(activeProperty.eq((Object)true));
            });
            actionableDynamicQuery.setPerformActionMethod(this::_reindex);
            actionableDynamicQuery.performActions();
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)this._segmentsConfiguration.segmentsPreviewCheckInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
    }

    private void _reindex(SegmentsEntry segmentsEntry) {
        Message message = new Message();
        message.put("companyId", (Object)segmentsEntry.getCompanyId());
        message.put("segmentsEntryId", (Object)segmentsEntry.getSegmentsEntryId());
        message.put("type", (Object)segmentsEntry.getType());
        this._messageBus.sendMessage("liferay/segments_entry_reindex", message);
    }
}

