/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.matcher;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.segments.odata.matcher.ODataMatcher;
import java.util.Map;
import java.util.function.Predicate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"target.class.name=com.liferay.segments.model.SegmentsEntry"}, service={ODataMatcher.class})
public class SegmentsEntryODataMatcher
implements ODataMatcher<Map<?, ?>> {
    @Reference(target="(entity.model.name=Segment)")
    private EntityModel _entityModel;
    @Reference(target="(result.class.name=java.util.function.Predicate)")
    private ExpressionConvert<Predicate<Map<?, ?>>> _expressionConvert;
    @Reference(target="(entity.model.name=Segment)")
    private FilterParser _filterParser;

    public boolean matches(String filterString, Map<?, ?> pattern) throws PortalException {
        try {
            Predicate<Map<?, ?>> predicate = this._getPredicate(filterString);
            return predicate.test(pattern);
        }
        catch (Exception exception) {
            throw new PortalException("Unable to match filter: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private Predicate<Map<?, ?>> _getPredicate(String filterString) throws Exception {
        Filter filter = new Filter(this._filterParser.parse(filterString));
        try {
            return (Predicate)this._expressionConvert.convert(filter.getExpression(), LocaleUtil.getDefault(), this._entityModel);
        }
        catch (Exception exception) {
            throw new InvalidFilterException("Invalid filter: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

