/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserGroupRoleModelListener
extends BaseModelListener<UserGroupRole> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;
    @Reference
    private SegmentsEntryRetriever _segmentsEntryRetriever;

    public void onBeforeRemove(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            long[] segmentsEntryIds;
            for (long segmentsEntryId : segmentsEntryIds = this._segmentsEntryRetriever.getSegmentsEntryIds(userGroupRole.getGroupId(), userGroupRole.getUserId(), null)) {
                this._deleteSegmentsEntryId(userGroupRole, segmentsEntryId);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private void _deleteSegmentsEntryId(UserGroupRole userGroupRole, long segmentsEntryId) throws Exception {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return;
        }
        Criteria criteria = segmentsEntry.getCriteriaObj();
        Map filterStrings = criteria.getFilterStrings();
        for (Map.Entry entry : filterStrings.entrySet()) {
            long classNameId;
            String filterString = (String)entry.getValue();
            if (!filterString.contains("userGroupRoleIds") || !filterString.contains(String.valueOf(userGroupRole.getRoleId())) || !this._segmentsEntryRelLocalService.hasSegmentsEntryRel(segmentsEntryId, classNameId = this._classNameLocalService.getClassNameId(User.class), userGroupRole.getUserId())) continue;
            this._segmentsEntryRelLocalService.deleteSegmentsEntryRel(segmentsEntryId, classNameId, userGroupRole.getUserId());
        }
    }
}

