/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.retriever;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.odata.search.ODataSearchAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.User"}, service={ODataRetriever.class})
public class UserODataRetriever
implements ODataRetriever<User> {
    @Reference(target="(entity.model.name=User)")
    private EntityModel _entityModel;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private ODataSearchAdapter _oDataSearchAdapter;
    @Reference
    private UserLocalService _userLocalService;

    public List<User> getResults(long companyId, String filterString, Locale locale, int start, int end) throws PortalException {
        FilterParser filterParser = this._filterParserProvider.provide(this._entityModel);
        Hits hits = this._oDataSearchAdapter.search(companyId, filterParser, filterString, User.class.getName(), this._entityModel, locale, start, end);
        return this._getUsers(hits);
    }

    public int getResultsCount(long companyId, String filterString, Locale locale) throws PortalException {
        FilterParser filterParser = this._filterParserProvider.provide(this._entityModel);
        return this._oDataSearchAdapter.searchCount(companyId, filterParser, filterString, User.class.getName(), this._entityModel, locale);
    }

    private User _getUser(Document document) throws PortalException {
        long userId = GetterUtil.getLong((String)document.get("userId"));
        return this._userLocalService.getUser(userId);
    }

    private List<User> _getUsers(Hits hits) throws PortalException {
        Document[] documents = hits.getDocs();
        ArrayList<User> users = new ArrayList<User>(documents.length);
        for (Document document : documents) {
            users.add(this._getUser(document));
        }
        return users;
    }
}

