/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.entity;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnTable;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoTableTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.util.promise.Promise;

public abstract class BaseExpandoEntityModel
implements EntityModel {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected EntityModelFieldMapper entityModelFieldMapper;
    @Reference
    protected ExpandoBridgeIndexer expandoBridgeIndexer;
    @Reference
    protected ExpandoColumnLocalService expandoColumnLocalService;
    @Reference
    protected ExpandoTableLocalService expandoTableLocalService;
    @Reference
    protected ServiceComponentRuntime serviceComponentRuntime;
    private BundleContext _bundleContext;
    private Map<String, EntityField> _entityFieldsMap;
    private final DCLSingleton<Map<String, EntityField>> _entityFieldsMapDCLSingleton = new DCLSingleton();
    private volatile ServiceRegistration<?> _serviceRegistration;

    public Map<String, EntityField> getEntityFieldsMap() {
        return this._entityFieldsMap;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._entityFieldsMap = EntityModel.toEntityFieldsMap((EntityField[])this.getEntityFields());
        this._entityFieldsMap.put("customField", (EntityField)new LazyComplexEntityField("customField"));
    }

    @Deactivate
    protected void deactivate() {
        ServiceRegistration<?> serviceRegistration = this._serviceRegistration;
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    protected abstract EntityField[] getEntityFields();

    protected abstract String getModelClassName();

    private Map<String, EntityField> _createEntityFieldsMap() {
        this._serviceRegistration = this._bundleContext.registerService(ModelListener.class, (Object)new ExpandoColumnModelListener(), null);
        HashMap<String, EntityField> entityFieldsMap = new HashMap<String, EntityField>();
        long classNameId = this.classNameLocalService.getClassNameId(this.getModelClassName());
        List expandoColumns = (List)this.expandoColumnLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ExpandoColumnTable.INSTANCE).from((Table)ExpandoColumnTable.INSTANCE).where(ExpandoColumnTable.INSTANCE.tableId.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{ExpandoTableTable.INSTANCE.tableId}).from((Table)ExpandoTableTable.INSTANCE).where(ExpandoTableTable.INSTANCE.classNameId.eq((Object)classNameId).and((Expression)ExpandoTableTable.INSTANCE.name.eq((Object)"CUSTOM_FIELDS"))))));
        for (ExpandoColumn expandoColumn : expandoColumns) {
            EntityField entityField = this._getEntityField(expandoColumn);
            if (entityField == null) continue;
            entityFieldsMap.put(entityField.getName(), entityField);
        }
        return entityFieldsMap;
    }

    private EntityField _getEntityField(ExpandoColumn expandoColumn) {
        if (!this._isIndexType(expandoColumn)) {
            return null;
        }
        Object entityField = null;
        String encodedName = this.entityModelFieldMapper.getExpandoColumnEntityFieldName(expandoColumn);
        String encodedIndexedFieldName = this.expandoBridgeIndexer.encodeFieldName(expandoColumn);
        entityField = expandoColumn.getType() == 1 ? new BooleanEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 3 ? new DateTimeEntityField(encodedName, locale -> Field.getSortableFieldName((String)encodedIndexedFieldName), locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 5 || expandoColumn.getType() == 6 || expandoColumn.getType() == 7 || expandoColumn.getType() == 8 ? new DoubleEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 9 || expandoColumn.getType() == 10 || expandoColumn.getType() == 11 || expandoColumn.getType() == 12 || expandoColumn.getType() == 13 || expandoColumn.getType() == 14 ? new IntegerEntityField(encodedName, locale -> encodedIndexedFieldName) : (expandoColumn.getType() == 20 ? new StringEntityField(encodedName, locale -> Field.getLocalizedName((Locale)locale, (String)encodedIndexedFieldName)) : new StringEntityField(encodedName, locale -> encodedIndexedFieldName)))));
        return entityField;
    }

    private boolean _isIndexType(ExpandoColumn expandoColumn) {
        if (expandoColumn == null) {
            return false;
        }
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        int indexType = GetterUtil.getInteger((String)((String)unicodeProperties.get((Object)"index-type")));
        return indexType != 0;
    }

    private void _refresh() {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Class<?> clazz = this.getClass();
            ComponentDescriptionDTO componentDescriptionDTO = this.serviceComponentRuntime.getComponentDescriptionDTO(FrameworkUtil.getBundle(BaseExpandoEntityModel.class), clazz.getName());
            Promise promise = this.serviceComponentRuntime.disableComponent(componentDescriptionDTO);
            promise.getValue();
            promise = this.serviceComponentRuntime.enableComponent(componentDescriptionDTO);
            promise.getValue();
            return null;
        });
    }

    private class LazyComplexEntityField
    extends ComplexEntityField {
        public Map<String, EntityField> getEntityFieldsMap() {
            return (Map)BaseExpandoEntityModel.this._entityFieldsMapDCLSingleton.getSingleton(BaseExpandoEntityModel.this::_createEntityFieldsMap);
        }

        private LazyComplexEntityField(String name) {
            super(name, Collections.emptyList());
        }
    }

    private class ExpandoColumnModelListener
    extends BaseModelListener<ExpandoColumn> {
        private final long _classNameId;

        public void onAfterCreate(ExpandoColumn expandoColumn) throws ModelListenerException {
            if (this._isTargetTable(expandoColumn) && BaseExpandoEntityModel.this._isIndexType(expandoColumn)) {
                BaseExpandoEntityModel.this._refresh();
            }
        }

        public void onAfterRemove(ExpandoColumn expandoColumn) throws ModelListenerException {
            if (this._isTargetTable(expandoColumn) && BaseExpandoEntityModel.this._isIndexType(expandoColumn)) {
                BaseExpandoEntityModel.this._refresh();
            }
        }

        public void onAfterUpdate(ExpandoColumn originalExpandoColumn, ExpandoColumn expandoColumn) throws ModelListenerException {
            if (this._isTargetTable(expandoColumn) && (BaseExpandoEntityModel.this._isIndexType(originalExpandoColumn) || BaseExpandoEntityModel.this._isIndexType(expandoColumn))) {
                BaseExpandoEntityModel.this._refresh();
            }
        }

        private ExpandoColumnModelListener() {
            this._classNameId = BaseExpandoEntityModel.this.classNameLocalService.getClassNameId(BaseExpandoEntityModel.this.getModelClassName());
        }

        private boolean _isTargetTable(ExpandoColumn expandoColumn) {
            try {
                ExpandoTable expandoTable = BaseExpandoEntityModel.this.expandoTableLocalService.getTable(expandoColumn.getTableId());
                return this._classNameId == expandoTable.getClassNameId() && "CUSTOM_FIELDS".equals(expandoTable.getName());
            }
            catch (PortalException portalException) {
                throw new ModelListenerException((Throwable)portalException);
            }
        }
    }
}

