/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.retriever;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.odata.search.ODataSearchAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.User"}, service={ODataRetriever.class})
public class UserODataRetriever
implements ODataRetriever<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserODataRetriever.class);
    private volatile EntityModel _entityModel;
    private FilterParser _filterParser;
    @Reference
    private ODataSearchAdapter _oDataSearchAdapter;
    @Reference
    private UserLocalService _userLocalService;

    public List<User> getResults(long companyId, String filterString, Locale locale, int start, int end) throws PortalException {
        Hits hits = this._oDataSearchAdapter.search(companyId, this._filterParser, filterString, User.class.getName(), this._entityModel, locale, start, end);
        return this._getUsers(hits);
    }

    public int getResultsCount(long companyId, String filterString, Locale locale) throws PortalException {
        return this._oDataSearchAdapter.searchCount(companyId, this._filterParser, filterString, User.class.getName(), this._entityModel, locale);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=User)", unbind="unbindFilterParser")
    public void setFilterParser(FilterParser filterParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + filterParser));
        }
        this._filterParser = filterParser;
    }

    public void unbindFilterParser(FilterParser filterParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + filterParser));
        }
        this._filterParser = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=User)", unbind="unbindEntityModel")
    protected void setEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + entityModel));
        }
        this._entityModel = entityModel;
    }

    protected void unbindEntityModel(EntityModel entityModel) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + entityModel));
        }
        this._entityModel = null;
    }

    private User _getUser(Document document) throws PortalException {
        long userId = GetterUtil.getLong((String)document.get("userId"));
        return this._userLocalService.getUser(userId);
    }

    private List<User> _getUsers(Hits hits) throws PortalException {
        Document[] documents = hits.getDocs();
        ArrayList<User> users = new ArrayList<User>(documents.length);
        for (Document document : documents) {
            users.add(this._getUser(document));
        }
        return users;
    }
}

