/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.events;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.SegmentsConfiguration;
import com.liferay.segments.context.RequestContextMapper;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessorRegistry;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.configuration.SegmentsConfiguration"}, service={})
public class SegmentsServicePreAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsServicePreAction.class);
    @Reference
    private Portal _portal;
    @Reference
    private RequestContextMapper _requestContextMapper;
    @Reference
    private volatile SegmentsEntryRetriever _segmentsEntryRetriever;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperienceRequestProcessorRegistry _segmentsExperienceRequestProcessorRegistry;
    private ServiceRegistration<LifecycleAction> _serviceRegistration;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ActionException {
        try {
            this.doRun(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ActionException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        SegmentsConfiguration segmentsConfiguration = (SegmentsConfiguration)ConfigurableUtil.createConfigurable(SegmentsConfiguration.class, properties);
        if (segmentsConfiguration.segmentationEnabled()) {
            this._serviceRegistration = bundleContext.registerService(LifecycleAction.class, (Object)this, MapUtil.singletonDictionary((Object)"key", (Object)"servlet.service.events.pre"));
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    protected void doRun(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout == null || !layout.isTypeContent() || layout.isTypeControlPanel()) {
            return;
        }
        httpServletRequest.setAttribute("SEGMENTS_EXPERIENCE_IDS", (Object)this._getSegmentsExperienceIds(httpServletRequest, httpServletResponse, layout.getGroupId(), themeDisplay.getUserId(), this._portal.getClassNameId(Layout.class.getName()), layout.getPlid()));
    }

    private long[] _getSegmentsExperienceIds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long groupId, long userId, long classNameId, long classPK) {
        try {
            long[] segmentsExperienceIds = this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, classNameId, classPK);
            if (segmentsExperienceIds.length == 0) {
                return new long[]{0L};
            }
            HashSet<Long> segmentsExperienceIdsSegmentsEntryIds = new HashSet<Long>();
            for (long segmentsExperienceId : segmentsExperienceIds) {
                SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
                if (segmentsExperience != null) {
                    segmentsExperienceIdsSegmentsEntryIds.add(segmentsExperience.getSegmentsEntryId());
                    continue;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to get segments experience " + segmentsExperienceId));
            }
            long[] cachedSegmentsEntryIds = (long[])httpServletRequest.getAttribute("SEGMENTS_ENTRY_IDS");
            long[] segmentsEntryIds = null;
            segmentsEntryIds = cachedSegmentsEntryIds != null ? cachedSegmentsEntryIds : this._segmentsEntryRetriever.getSegmentsEntryIds(groupId, userId, this._requestContextMapper.map(httpServletRequest), ArrayUtil.toArray((Long[])segmentsExperienceIdsSegmentsEntryIds.toArray(new Long[0])));
            httpServletRequest.setAttribute("SEGMENTS_ENTRY_IDS", (Object)segmentsEntryIds);
            return ArrayUtil.append((long[])this._segmentsExperienceRequestProcessorRegistry.getSegmentsExperienceIds(httpServletRequest, httpServletResponse, groupId, classNameId, classPK, segmentsEntryIds), (long)0L);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)portalException, (Throwable)portalException);
            }
            return new long[]{0L};
        }
    }
}

