/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.BrowseRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.CustomFieldRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.LanguageRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.LastLoginDateRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.OSRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.OrganizationMemberRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.PreviousVisitedSiteRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.RegularRoleRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.RuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.SiteMemberRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.UserGroupMemberRuleConverter;
import com.liferay.segments.content.targeting.upgrade.internal.upgrade.v1_0_0.util.UserLoggedRuleConverter;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.CriteriaSerializer;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.service.SegmentsEntryLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ContentTargetingUpgradeProcess
extends UpgradeProcess {
    private static final String _CT_PACKAGE_NAME = "com.liferay.content.targeting";
    private static final Log _log = LogFactoryUtil.getLog(ContentTargetingUpgradeProcess.class);
    private final Map<String, RuleConverter> _ruleConverters = new HashMap<String, RuleConverter>();
    private final SegmentsEntryLocalService _segmentsEntryLocalService;

    public ContentTargetingUpgradeProcess(ExpandoColumnLocalService expandoColumnLocalService, ExpandoTableLocalService expandoTableLocalService, JSONFactory jsonFactory, SegmentsEntryLocalService segmentsEntryLocalService, SegmentsCriteriaContributor userOrganizationSegmentsCriteriaContributor, SegmentsCriteriaContributor userSegmentsCriteriaContributor) {
        this._segmentsEntryLocalService = segmentsEntryLocalService;
        this._ruleConverters.put("BrowserRule", new BrowseRuleConverter());
        this._ruleConverters.put("CustomFieldRule", new CustomFieldRuleConverter(expandoColumnLocalService, expandoTableLocalService, jsonFactory, userSegmentsCriteriaContributor));
        this._ruleConverters.put("LanguageRule", new LanguageRuleConverter());
        this._ruleConverters.put("LastLoginDateRule", new LastLoginDateRuleConverter(jsonFactory));
        this._ruleConverters.put("OrganizationMemberRule", new OrganizationMemberRuleConverter(userOrganizationSegmentsCriteriaContributor));
        this._ruleConverters.put("OSRule", new OSRuleConverter());
        this._ruleConverters.put("PreviousVisitedSiteRule", new PreviousVisitedSiteRuleConverter(jsonFactory));
        this._ruleConverters.put("RegularRoleRule", new RegularRoleRuleConverter(userSegmentsCriteriaContributor));
        this._ruleConverters.put("SiteMemberRule", new SiteMemberRuleConverter(userSegmentsCriteriaContributor));
        this._ruleConverters.put("UserGroupMemberRule", new UserGroupMemberRuleConverter(userSegmentsCriteriaContributor));
        this._ruleConverters.put("UserLoggedRule", new UserLoggedRuleConverter());
    }

    public void doUpgrade() throws Exception {
        if (!this.hasTable("CT_UserSegment")) {
            return;
        }
        this._upgradeContentTargetingUserSegments();
        this._deleteContentTargetingData();
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropTables((String[])new String[]{"CT_AU_AnonymousUser", "CT_Analytics_AnalyticsEvent", "CT_Analytics_AnalyticsReferrer", "CT_AnonymousUserUserSegment", "CT_CCR_CampaignContent", "CT_CTA_CTAction", "CT_CTA_CTActionTotal", "CT_Campaign", "CT_Campaigns_UserSegments", "CT_ChannelInstance", "CT_ReportInstance", "CT_RuleInstance", "CT_ScorePoints_ScorePoint", "CT_Tactic", "CT_Tactics_UserSegments", "CT_TrackingActionInstance", "CT_USCR_UserSegmentContent", "CT_UserSegment", "CT_Visited_ContentVisited", "CT_Visited_PageVisited"})};
    }

    private void _deleteContentTargetingData() throws Exception {
        this.runSQL("delete from ClassName_ where value like 'com.liferay.content.targeting%'");
        this.runSQL("delete from Release_ where servletContextName like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ResourceAction where name like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ResourcePermission where name like 'com.liferay.content.targeting%'");
        this.runSQL("delete from ServiceComponent where buildNamespace like 'CT%'");
    }

    private String _getCriteria(long userSegmentId) throws Exception {
        Criteria criteria = new Criteria();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, ruleKey, typeSettings from CT_RuleInstance where userSegmentId = ?");){
            preparedStatement.setLong(1, userSegmentId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String ruleKey = resultSet.getString("ruleKey");
                    RuleConverter ruleConverter = this._ruleConverters.get(ruleKey);
                    if (ruleConverter == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Unable to perform automated update of rule " + ruleKey));
                        continue;
                    }
                    long companyId = resultSet.getLong("companyId");
                    String typeSettings = resultSet.getString("typeSettings");
                    ruleConverter.convert(companyId, criteria, typeSettings);
                }
            }
        }
        return CriteriaSerializer.serialize((Criteria)criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _upgradeContentTargetingUserSegments() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from CT_UserSegment");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            ServiceContext serviceContext = new ServiceContext();
            while (resultSet.next()) {
                long userSegmentId = resultSet.getLong("userSegmentId");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Upgrading Content Targeting User Segment " + userSegmentId));
                }
                String name = resultSet.getString("name");
                Map nameMap = LocalizationUtil.getLocalizationMap((String)name);
                Map descriptionMap = LocalizationUtil.getLocalizationMap((String)resultSet.getString("description"));
                serviceContext.setScopeGroupId(resultSet.getLong("groupId"));
                serviceContext.setUserId(PortalUtil.getValidUserId((long)resultSet.getLong("companyId"), (long)resultSet.getLong("userId")));
                Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)name));
                Locale currentDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
                try {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)defaultLocale);
                    this._segmentsEntryLocalService.addSegmentsEntry("ct_" + userSegmentId, nameMap, descriptionMap, true, this._getCriteria(userSegmentId), "DEFAULT", serviceContext);
                }
                finally {
                    LocaleThreadLocal.setSiteDefaultLocale((Locale)currentDefaultLocale);
                }
            }
        }
    }
}

