/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saved.content.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.saved.content.exception.DuplicateSavedContentEntryException;
import com.liferay.saved.content.exception.NoSuchSavedContentEntryException;
import com.liferay.saved.content.model.SavedContentEntry;
import com.liferay.saved.content.service.base.SavedContentEntryLocalServiceBaseImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saved.content.model.SavedContentEntry"}, service={AopService.class})
public class SavedContentEntryLocalServiceImpl
extends SavedContentEntryLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public SavedContentEntry addSavedContentEntry(long userId, long groupId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        SavedContentEntry savedContentEntry = this.savedContentEntryPersistence.fetchByG_U_C_C(groupId, userId, classNameId, classPK);
        if (savedContentEntry != null) {
            throw new DuplicateSavedContentEntryException();
        }
        savedContentEntry = this.savedContentEntryPersistence.create(this.counterLocalService.increment(SavedContentEntry.class.getName()));
        savedContentEntry.setGroupId(groupId);
        User user = this._userLocalService.getUserById(userId);
        savedContentEntry.setUserId(user.getUserId());
        savedContentEntry.setUserName(user.getFullName());
        savedContentEntry.setClassNameId(classNameId);
        savedContentEntry.setClassPK(classPK);
        savedContentEntry = (SavedContentEntry)this.savedContentEntryPersistence.update((BaseModel)savedContentEntry);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this._resourceLocalService.addResources(savedContentEntry.getCompanyId(), savedContentEntry.getGroupId(), savedContentEntry.getUserId(), SavedContentEntry.class.getName(), savedContentEntry.getSavedContentEntryId(), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this._resourceLocalService.addModelResources(savedContentEntry.getCompanyId(), savedContentEntry.getGroupId(), savedContentEntry.getUserId(), SavedContentEntry.class.getName(), savedContentEntry.getSavedContentEntryId(), serviceContext.getModelPermissions());
        }
        return savedContentEntry;
    }

    public void deleteSavedContentEntries(long groupId, long classNameId, long classPK) {
        this.savedContentEntryPersistence.removeByG_C_C(groupId, classNameId, classPK);
    }

    public void deleteSavedContentEntriesByUserId(long userId) {
        this.savedContentEntryPersistence.removeByUserId(userId);
    }

    public SavedContentEntry fetchSavedContentEntry(long userId, long groupId, String className, long classPK) {
        return this.savedContentEntryPersistence.fetchByG_U_C_C(groupId, userId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public SavedContentEntry getSavedContentEntry(long userId, long groupId, String className, long classPK) throws NoSuchSavedContentEntryException {
        return this.savedContentEntryPersistence.findByG_U_C_C(groupId, userId, this._classNameLocalService.getClassNameId(className), classPK);
    }
}

