/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model.impl;

import com.liferay.saml.persistence.model.SamlIbSloMessage;
import com.liferay.saml.persistence.service.SamlIbSloMessageLocalServiceUtil;

/**
 * The extended model base implementation for the SamlIbSloMessage service. Represents a row in the &quot;SamlIbSloMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SamlIbSloMessageImpl}.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlIbSloMessageImpl
 * @see SamlIbSloMessage
 * @generated
 */
public abstract class SamlIbSloMessageBaseImpl
	extends SamlIbSloMessageModelImpl implements SamlIbSloMessage {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saml ib slo message model instance should use the <code>SamlIbSloMessage</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SamlIbSloMessageLocalServiceUtil.addSamlIbSloMessage(this);
		}
		else {
			SamlIbSloMessageLocalServiceUtil.updateSamlIbSloMessage(this);
		}
	}

}