/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.service.base.SamlPeerBindingLocalServiceBaseImpl;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saml.persistence.model.SamlPeerBinding"}, service={AopService.class})
public class SamlPeerBindingLocalServiceImpl
extends SamlPeerBindingLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public SamlPeerBinding addSamlPeerBinding(long userId, String samlPeerEntityId, String samlNameIdFormat, String samlNameIdNameQualifier, String samlNameIdSpNameQualifier, String samlNameIdSpProvidedId, String samlNameIdValue) throws PortalException {
        User user = this._userLocalService.getUserById(userId);
        SamlPeerBinding samlPeerBinding = this.samlPeerBindingPersistence.create(this.counterLocalService.increment(SamlPeerBinding.class.getName()));
        samlPeerBinding.setCompanyId(user.getCompanyId());
        samlPeerBinding.setUserId(user.getUserId());
        samlPeerBinding.setUserName(user.getFullName());
        samlPeerBinding.setSamlPeerEntityId(samlPeerEntityId);
        samlPeerBinding.setSamlNameIdFormat(samlNameIdFormat);
        samlPeerBinding.setSamlNameIdNameQualifier(samlNameIdNameQualifier);
        samlPeerBinding.setSamlNameIdSpNameQualifier(samlNameIdSpNameQualifier);
        samlPeerBinding.setSamlNameIdSpProvidedId(samlNameIdSpProvidedId);
        samlPeerBinding.setSamlNameIdValue(samlNameIdValue);
        return (SamlPeerBinding)this.samlPeerBindingPersistence.update((BaseModel)samlPeerBinding);
    }

    public SamlPeerBinding fetchSamlPeerBinding(long companyId, String samlPeerEntityId, boolean deleted, String samlNameIdFormat, String samlNameIdNameQualifier, String samlNameIdValue) {
        List<SamlPeerBinding> samlPeerBindings = this.getSamlPeerBindings(companyId, samlPeerEntityId, deleted, samlNameIdFormat, samlNameIdNameQualifier, samlNameIdValue);
        if (!samlPeerBindings.isEmpty()) {
            return samlPeerBindings.get(0);
        }
        return null;
    }

    public List<SamlPeerBinding> getSamlPeerBindings(long companyId, String samlPeerEntityId, boolean deleted, String samlNameIdFormat, String samlNameIdNameQualifier, String samlNameIdValue) {
        List samlPeerBindings = this.samlPeerBindingPersistence.findByC_D_SNIV(companyId, deleted, samlNameIdValue, -1, -1, null);
        return ListUtil.filter((List)samlPeerBindings, samlPeerBinding -> Objects.equals(GetterUtil.getString((String)samlPeerEntityId), samlPeerBinding.getSamlPeerEntityId()) && Objects.equals(GetterUtil.getString((String)samlNameIdFormat), samlPeerBinding.getSamlNameIdFormat()) && Objects.equals(GetterUtil.getString((String)samlNameIdNameQualifier), samlPeerBinding.getSamlNameIdNameQualifier()));
    }

    public List<SamlPeerBinding> getUserSamlPeerBindings(long userId, String samlPeerEntityId, boolean deleted, String samlNameIdFormat, String samlNameIdNameQualifier) throws PortalException {
        User user = this._userLocalService.getUserById(userId);
        List samlPeerBindings = this.samlPeerBindingPersistence.findByC_U_SPEI_D(user.getCompanyId(), userId, samlPeerEntityId, deleted, -1, -1);
        return ListUtil.filter((List)samlPeerBindings, samlPeerBinding -> Objects.equals(GetterUtil.getString((String)samlNameIdFormat), samlPeerBinding.getSamlNameIdFormat()) && Objects.equals(GetterUtil.getString((String)samlNameIdNameQualifier), samlPeerBinding.getSamlNameIdNameQualifier()));
    }
}

