/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.persistence.model.SamlIbSloMessage;
import com.liferay.saml.persistence.model.SamlIbSloMessageModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SamlIbSloMessage service. Represents a row in the &quot;SamlIbSloMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SamlIbSloMessageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SamlIbSloMessageImpl}.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlIbSloMessageImpl
 * @generated
 */
public class SamlIbSloMessageModelImpl
	extends BaseModelImpl<SamlIbSloMessage> implements SamlIbSloMessageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saml ib slo message model instance should use the <code>SamlIbSloMessage</code> interface instead.
	 */
	public static final String TABLE_NAME = "SamlIbSloMessage";

	public static final Object[][] TABLE_COLUMNS = {
		{"samlIbSloMessageId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"samlIdpEntityId", Types.VARCHAR},
		{"logoutRequestXml", Types.CLOB}, {"samlIdpSessionIndex", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("samlIbSloMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("samlIdpEntityId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("logoutRequestXml", Types.CLOB);
		TABLE_COLUMNS_MAP.put("samlIdpSessionIndex", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SamlIbSloMessage (samlIbSloMessageId LONG not null primary key,companyId LONG,createDate DATE null,samlIdpEntityId VARCHAR(1024) null,logoutRequestXml TEXT null,samlIdpSessionIndex VARCHAR(200) null)";

	public static final String TABLE_SQL_DROP = "drop table SamlIbSloMessage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY samlIbSloMessage.samlIbSloMessageId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SamlIbSloMessage.samlIbSloMessageId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLIDPSESSIONINDEX_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SAMLIBSLOMESSAGEID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public SamlIbSloMessageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _samlIbSloMessageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSamlIbSloMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _samlIbSloMessageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SamlIbSloMessage.class;
	}

	@Override
	public String getModelClassName() {
		return SamlIbSloMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SamlIbSloMessage, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SamlIbSloMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlIbSloMessage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SamlIbSloMessage)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SamlIbSloMessage, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SamlIbSloMessage, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SamlIbSloMessage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SamlIbSloMessage, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SamlIbSloMessage, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<SamlIbSloMessage, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<SamlIbSloMessage, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<SamlIbSloMessage, Object>>();

			attributeGetterFunctions.put(
				"samlIbSloMessageId", SamlIbSloMessage::getSamlIbSloMessageId);
			attributeGetterFunctions.put(
				"companyId", SamlIbSloMessage::getCompanyId);
			attributeGetterFunctions.put(
				"createDate", SamlIbSloMessage::getCreateDate);
			attributeGetterFunctions.put(
				"samlIdpEntityId", SamlIbSloMessage::getSamlIdpEntityId);
			attributeGetterFunctions.put(
				"logoutRequestXml", SamlIbSloMessage::getLogoutRequestXml);
			attributeGetterFunctions.put(
				"samlIdpSessionIndex",
				SamlIbSloMessage::getSamlIdpSessionIndex);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<SamlIbSloMessage, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<SamlIbSloMessage, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<SamlIbSloMessage, ?>>();

			attributeSetterBiConsumers.put(
				"samlIbSloMessageId",
				(BiConsumer<SamlIbSloMessage, Long>)
					SamlIbSloMessage::setSamlIbSloMessageId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<SamlIbSloMessage, Long>)
					SamlIbSloMessage::setCompanyId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<SamlIbSloMessage, Date>)
					SamlIbSloMessage::setCreateDate);
			attributeSetterBiConsumers.put(
				"samlIdpEntityId",
				(BiConsumer<SamlIbSloMessage, String>)
					SamlIbSloMessage::setSamlIdpEntityId);
			attributeSetterBiConsumers.put(
				"logoutRequestXml",
				(BiConsumer<SamlIbSloMessage, String>)
					SamlIbSloMessage::setLogoutRequestXml);
			attributeSetterBiConsumers.put(
				"samlIdpSessionIndex",
				(BiConsumer<SamlIbSloMessage, String>)
					SamlIbSloMessage::setSamlIdpSessionIndex);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getSamlIbSloMessageId() {
		return _samlIbSloMessageId;
	}

	@Override
	public void setSamlIbSloMessageId(long samlIbSloMessageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlIbSloMessageId = samlIbSloMessageId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public String getSamlIdpEntityId() {
		if (_samlIdpEntityId == null) {
			return "";
		}
		else {
			return _samlIdpEntityId;
		}
	}

	@Override
	public void setSamlIdpEntityId(String samlIdpEntityId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlIdpEntityId = samlIdpEntityId;
	}

	@Override
	public String getLogoutRequestXml() {
		if (_logoutRequestXml == null) {
			return "";
		}
		else {
			return _logoutRequestXml;
		}
	}

	@Override
	public void setLogoutRequestXml(String logoutRequestXml) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_logoutRequestXml = logoutRequestXml;
	}

	@Override
	public String getSamlIdpSessionIndex() {
		if (_samlIdpSessionIndex == null) {
			return "";
		}
		else {
			return _samlIdpSessionIndex;
		}
	}

	@Override
	public void setSamlIdpSessionIndex(String samlIdpSessionIndex) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_samlIdpSessionIndex = samlIdpSessionIndex;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalSamlIdpSessionIndex() {
		return getColumnOriginalValue("samlIdpSessionIndex");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SamlIbSloMessage.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SamlIbSloMessage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SamlIbSloMessage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SamlIbSloMessageImpl samlIbSloMessageImpl = new SamlIbSloMessageImpl();

		samlIbSloMessageImpl.setSamlIbSloMessageId(getSamlIbSloMessageId());
		samlIbSloMessageImpl.setCompanyId(getCompanyId());
		samlIbSloMessageImpl.setCreateDate(getCreateDate());
		samlIbSloMessageImpl.setSamlIdpEntityId(getSamlIdpEntityId());
		samlIbSloMessageImpl.setLogoutRequestXml(getLogoutRequestXml());
		samlIbSloMessageImpl.setSamlIdpSessionIndex(getSamlIdpSessionIndex());

		samlIbSloMessageImpl.resetOriginalValues();

		return samlIbSloMessageImpl;
	}

	@Override
	public SamlIbSloMessage cloneWithOriginalValues() {
		SamlIbSloMessageImpl samlIbSloMessageImpl = new SamlIbSloMessageImpl();

		samlIbSloMessageImpl.setSamlIbSloMessageId(
			this.<Long>getColumnOriginalValue("samlIbSloMessageId"));
		samlIbSloMessageImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		samlIbSloMessageImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		samlIbSloMessageImpl.setSamlIdpEntityId(
			this.<String>getColumnOriginalValue("samlIdpEntityId"));
		samlIbSloMessageImpl.setLogoutRequestXml(
			this.<String>getColumnOriginalValue("logoutRequestXml"));
		samlIbSloMessageImpl.setSamlIdpSessionIndex(
			this.<String>getColumnOriginalValue("samlIdpSessionIndex"));

		return samlIbSloMessageImpl;
	}

	@Override
	public int compareTo(SamlIbSloMessage samlIbSloMessage) {
		long primaryKey = samlIbSloMessage.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SamlIbSloMessage)) {
			return false;
		}

		SamlIbSloMessage samlIbSloMessage = (SamlIbSloMessage)object;

		long primaryKey = samlIbSloMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SamlIbSloMessage> toCacheModel() {
		SamlIbSloMessageCacheModel samlIbSloMessageCacheModel =
			new SamlIbSloMessageCacheModel();

		samlIbSloMessageCacheModel.samlIbSloMessageId = getSamlIbSloMessageId();

		samlIbSloMessageCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			samlIbSloMessageCacheModel.createDate = createDate.getTime();
		}
		else {
			samlIbSloMessageCacheModel.createDate = Long.MIN_VALUE;
		}

		samlIbSloMessageCacheModel.samlIdpEntityId = getSamlIdpEntityId();

		String samlIdpEntityId = samlIbSloMessageCacheModel.samlIdpEntityId;

		if ((samlIdpEntityId != null) && (samlIdpEntityId.length() == 0)) {
			samlIbSloMessageCacheModel.samlIdpEntityId = null;
		}

		samlIbSloMessageCacheModel.logoutRequestXml = getLogoutRequestXml();

		String logoutRequestXml = samlIbSloMessageCacheModel.logoutRequestXml;

		if ((logoutRequestXml != null) && (logoutRequestXml.length() == 0)) {
			samlIbSloMessageCacheModel.logoutRequestXml = null;
		}

		samlIbSloMessageCacheModel.samlIdpSessionIndex =
			getSamlIdpSessionIndex();

		String samlIdpSessionIndex =
			samlIbSloMessageCacheModel.samlIdpSessionIndex;

		if ((samlIdpSessionIndex != null) &&
			(samlIdpSessionIndex.length() == 0)) {

			samlIbSloMessageCacheModel.samlIdpSessionIndex = null;
		}

		return samlIbSloMessageCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SamlIbSloMessage, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SamlIbSloMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SamlIbSloMessage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(SamlIbSloMessage)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SamlIbSloMessage>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SamlIbSloMessage.class, ModelWrapper.class);

	}

	private long _samlIbSloMessageId;
	private long _companyId;
	private Date _createDate;
	private String _samlIdpEntityId;
	private String _logoutRequestXml;
	private String _samlIdpSessionIndex;

	public <T> T getColumnValue(String columnName) {
		Function<SamlIbSloMessage, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SamlIbSloMessage)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("samlIbSloMessageId", _samlIbSloMessageId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("samlIdpEntityId", _samlIdpEntityId);
		_columnOriginalValues.put("logoutRequestXml", _logoutRequestXml);
		_columnOriginalValues.put("samlIdpSessionIndex", _samlIdpSessionIndex);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("samlIbSloMessageId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("createDate", 4L);

		columnBitmasks.put("samlIdpEntityId", 8L);

		columnBitmasks.put("logoutRequestXml", 16L);

		columnBitmasks.put("samlIdpSessionIndex", 32L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SamlIbSloMessage _escapedModel;

}