/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.internal.upgrade.v3_0_0;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SamlIdpSpSessionUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.alterTableAddColumn("SamlIdpSpSession", "samlPeerBindingId", "LONG null");
            this.runSQL("delete from SamlPeerBinding");
            int latestSamlPeerBindingId = this._getLatestSamlPeerBindingId();
            int samlIdpSpSessionIdOffset = this._getSamlIdpSpSessionIdOffset();
            String sql1 = StringBundler.concat((String[])new String[]{"select min(samlIdpSpSessionId) as samlIdpSpSessionId, ", "companyId, min(createDate) as createDate, userId, userName, ", "nameIdFormat, nameIdValue, samlSpEntityId from ", "SamlIdpSpSession group by companyId, userId, userName, ", "nameIdFormat, nameIdValue, samlSpEntityId"});
            String sql2 = StringBundler.concat((String[])new String[]{"insert into SamlPeerBinding (samlPeerBindingId, companyId, ", "createDate, userId, userName, deleted, samlNameIdFormat, ", "samlNameIdNameQualifier, samlNameIdSpNameQualifier, ", "samlNameIdSpProvidedId, samlNameIdValue, samlPeerEntityId) ", "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"});
            try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sql1);
                 ResultSet resultSet = preparedStatement1.executeQuery();
                 PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sql2);){
                while (resultSet.next()) {
                    preparedStatement2.setInt(1, resultSet.getInt("samlIdpSpSessionId") + -samlIdpSpSessionIdOffset + latestSamlPeerBindingId);
                    preparedStatement2.setLong(2, resultSet.getLong("companyId"));
                    preparedStatement2.setTimestamp(3, resultSet.getTimestamp("createDate"));
                    preparedStatement2.setLong(4, resultSet.getLong("userId"));
                    preparedStatement2.setString(5, resultSet.getString("userName"));
                    preparedStatement2.setBoolean(6, false);
                    preparedStatement2.setString(7, resultSet.getString("nameIdFormat"));
                    preparedStatement2.setString(8, null);
                    preparedStatement2.setString(9, null);
                    preparedStatement2.setString(10, null);
                    preparedStatement2.setString(11, resultSet.getString("nameIdValue"));
                    preparedStatement2.setString(12, resultSet.getString("samlSpEntityId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
            this.runSQL(StringBundler.concat((String[])new String[]{"update SamlIdpSpSession set samlPeerBindingId = (", "select samlPeerBindingId from SamlPeerBinding where ", "SamlIdpSpSession.companyId = SamlPeerBinding.companyId ", "and SamlIdpSpSession.userId = SamlPeerBinding.userId and ", "SamlIdpSpSession.samlSpEntityId = ", "SamlPeerBinding.samlPeerEntityId and ", "SamlIdpSpSession.nameIdFormat = ", "SamlPeerBinding.samlNameIdFormat and ", "SamlIdpSpSession.nameIdValue = ", "SamlPeerBinding.samlNameIdValue)"}));
            CounterLocalServiceUtil.reset((String)"com.liferay.saml.persistence.model.SamlPeerBinding", (long)(this._getLatestSamlPeerBindingId() + 1));
        }
    }

    private int _getLatestSamlPeerBindingId() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select max(samlPeerBindingId) from SamlPeerBinding");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    private int _getSamlIdpSpSessionIdOffset() throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select min(samlIdpSpSessionId) - 1 from SamlIdpSpSession");
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }
}

