/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model.impl;

import com.liferay.saml.persistence.model.SamlSpAuthRequest;
import com.liferay.saml.persistence.service.SamlSpAuthRequestLocalServiceUtil;

/**
 * The extended model base implementation for the SamlSpAuthRequest service. Represents a row in the &quot;SamlSpAuthRequest&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SamlSpAuthRequestImpl}.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlSpAuthRequestImpl
 * @see SamlSpAuthRequest
 * @generated
 */
public abstract class SamlSpAuthRequestBaseImpl
	extends SamlSpAuthRequestModelImpl implements SamlSpAuthRequest {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saml sp auth request model instance should use the <code>SamlSpAuthRequest</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SamlSpAuthRequestLocalServiceUtil.addSamlSpAuthRequest(this);
		}
		else {
			SamlSpAuthRequestLocalServiceUtil.updateSamlSpAuthRequest(this);
		}
	}

}