/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.service.base.SamlPeerBindingLocalServiceBaseImpl;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saml.persistence.model.SamlPeerBinding"}, service={AopService.class})
public class SamlPeerBindingLocalServiceImpl
extends SamlPeerBindingLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public SamlPeerBinding addSamlPeerBinding(long userId, String samlNameIdFormat, String samlNameIdNameQualifier, String samlNameIdSpNameQualifier, String samlNameIdSpProvidedId, String samlNameIdValue, String samlPeerEntityId) throws PortalException {
        User user = this._userLocalService.getUserById(userId);
        SamlPeerBinding samlPeerBinding = this.samlPeerBindingPersistence.create(this.counterLocalService.increment(SamlPeerBinding.class.getName()));
        samlPeerBinding.setCompanyId(user.getCompanyId());
        samlPeerBinding.setUserId(user.getUserId());
        samlPeerBinding.setUserName(user.getFullName());
        samlPeerBinding.setSamlNameIdFormat(samlNameIdFormat);
        samlPeerBinding.setSamlNameIdSpNameQualifier(samlNameIdSpNameQualifier);
        samlPeerBinding.setSamlNameIdSpProvidedId(samlNameIdSpProvidedId);
        samlPeerBinding.setSamlNameIdValue(samlNameIdValue);
        samlPeerBinding.setSamlPeerEntityId(samlPeerEntityId);
        return (SamlPeerBinding)this.samlPeerBindingPersistence.update((BaseModel)samlPeerBinding);
    }

    public SamlPeerBinding fetchSamlPeerBinding(long companyId, boolean deleted, String samlNameIdFormat, String samlNameIdNameQualifier, String samlNameIdValue, String samlPeerEntityId) {
        List<SamlPeerBinding> samlPeerBindings = this.getSamlPeerBindings(companyId, deleted, samlNameIdFormat, samlNameIdNameQualifier, samlNameIdValue, samlPeerEntityId);
        if (!samlPeerBindings.isEmpty()) {
            return samlPeerBindings.get(0);
        }
        return null;
    }

    public List<SamlPeerBinding> getSamlPeerBindings(long companyId, boolean deleted, String samlNameIdFormat, String samlNameIdNameQualifier, String samlNameIdValue, String samlPeerEntityId) {
        List samlPeerBindings = this.samlPeerBindingPersistence.findByC_D_SNIV(companyId, deleted, samlNameIdValue, -1, -1, null);
        return ListUtil.filter((List)samlPeerBindings, samlPeerBinding -> Objects.equals(GetterUtil.getString((String)samlNameIdFormat), samlPeerBinding.getSamlNameIdFormat()) && Objects.equals(GetterUtil.getString((String)samlNameIdNameQualifier), samlPeerBinding.getSamlNameIdNameQualifier()) && Objects.equals(GetterUtil.getString((String)samlPeerEntityId), samlPeerBinding.getSamlPeerEntityId()));
    }

    public List<SamlPeerBinding> getUserSamlPeerBindings(long userId, boolean deleted, String samlNameIdFormat, String samlNameIdNameQualifier, String samlPeerEntityId) throws PortalException {
        User user = this._userLocalService.getUserById(userId);
        List samlPeerBindings = this.samlPeerBindingPersistence.findByC_U_D_SPEI(user.getCompanyId(), userId, deleted, samlPeerEntityId, -1, -1);
        return ListUtil.filter((List)samlPeerBindings, samlPeerBinding -> Objects.equals(GetterUtil.getString((String)samlNameIdFormat), samlPeerBinding.getSamlNameIdFormat()) && Objects.equals(GetterUtil.getString((String)samlNameIdNameQualifier), samlPeerBinding.getSamlNameIdNameQualifier()));
    }
}

