/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.saml.persistence.internal.util.SamlConfigurationUtil;
import com.liferay.saml.persistence.model.SamlSpAuthRequest;
import com.liferay.saml.persistence.service.base.SamlSpAuthRequestLocalServiceBaseImpl;
import com.liferay.saml.runtime.configuration.SamlConfiguration;
import java.util.Date;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saml.persistence.model.SamlSpAuthRequest"}, service={AopService.class})
public class SamlSpAuthRequestLocalServiceImpl
extends SamlSpAuthRequestLocalServiceBaseImpl {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private SamlConfiguration _samlConfiguration;

    public SamlSpAuthRequest addSamlSpAuthRequest(String samlIdpEntityId, String samlSpAuthRequestKey, ServiceContext serviceContext) {
        long samlSpAuthRequestId = this.counterLocalService.increment(SamlSpAuthRequest.class.getName());
        SamlSpAuthRequest samlSpAuthRequest = this.samlSpAuthRequestPersistence.create(samlSpAuthRequestId);
        samlSpAuthRequest.setCompanyId(serviceContext.getCompanyId());
        samlSpAuthRequest.setCreateDate(new Date());
        samlSpAuthRequest.setSamlIdpEntityId(samlIdpEntityId);
        samlSpAuthRequest.setSamlSpAuthRequestKey(samlSpAuthRequestKey);
        return (SamlSpAuthRequest)this.samlSpAuthRequestPersistence.update((BaseModel)samlSpAuthRequest);
    }

    public void deleteExpiredSamlSpAuthRequests() {
        Date createDate = new Date();
        createDate.setTime(createDate.getTime() - (long)this._samlConfiguration.getSpAuthRequestMaxAge());
        this.samlSpAuthRequestPersistence.removeByCreateDate(createDate);
    }

    public SamlSpAuthRequest fetchSamlSpAuthRequest(String samlIdpEntityId, String samlSpAuthRequestKey) {
        return this.samlSpAuthRequestPersistence.fetchBySIEI_SSARK(samlIdpEntityId, samlSpAuthRequestKey);
    }

    public SamlSpAuthRequest getSamlSpAuthRequest(String samlIdpEntityId, String samlSpAuthRequestKey) throws PortalException {
        return this.samlSpAuthRequestPersistence.findBySIEI_SSARK(samlIdpEntityId, samlSpAuthRequestKey);
    }

    @Activate
    protected void activate() {
        this._samlConfiguration = SamlConfigurationUtil.getSamlConfiguration(this._configurationAdmin);
    }
}

