/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.saml.persistence.model.impl.SamlIdpSsoSessionBaseImpl;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelperUtil;
import java.util.Date;

public class SamlIdpSsoSessionImpl
extends SamlIdpSsoSessionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(SamlIdpSsoSessionImpl.class);

    public boolean isExpired() {
        long samlIdpSessionTimeout;
        SamlProviderConfiguration samlProviderConfiguration = SamlProviderConfigurationHelperUtil.getSamlProviderConfiguration();
        if (samlProviderConfiguration == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get SAML provider configuration");
            }
            return true;
        }
        long samlIdpSessionMaximumAge = samlProviderConfiguration.sessionMaximumAge();
        if (samlIdpSessionMaximumAge > 0L) {
            Date createDate = this.getCreateDate();
            long expirationTime = createDate.getTime() + samlIdpSessionMaximumAge * 1000L;
            if (System.currentTimeMillis() > expirationTime) {
                return true;
            }
        }
        if ((samlIdpSessionTimeout = samlProviderConfiguration.sessionTimeout()) <= 0L) {
            return false;
        }
        Date modifiedDate = this.getModifiedDate();
        long expirationTime = modifiedDate.getTime() + samlIdpSessionTimeout * 1000L;
        return System.currentTimeMillis() > expirationTime;
    }
}

