/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.internal.upgrade.v1_1_4;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class UpgradeSamlSpSessionData
extends UpgradeProcess {
    private static final String _FACTORY_PID = SamlProviderConfiguration.class.getName();
    private final ConfigurationAdmin _configurationAdmin;

    public UpgradeSamlSpSessionData(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    public void migrateSAMLProviderConfiguration() throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(&(", "service.factoryPid", "=", _FACTORY_PID, ")(companyId=*))"}));
        if (configurations == null) {
            return;
        }
        for (Configuration configuration : configurations) {
            String samlSpDefaultIdpEntityId;
            Dictionary properties = configuration.getProperties();
            long companyId = GetterUtil.getLong(properties.get("companyId"), (long)-1L);
            if (companyId < 1L || Validator.isBlank((String)(samlSpDefaultIdpEntityId = GetterUtil.getString(properties.get("saml.sp.default.idp.entity.id"))))) continue;
            this.runSQL(StringBundler.concat((String[])new String[]{"update SamlSpSession set samlIdpEntityId = '", samlSpDefaultIdpEntityId, "' where companyId = ", String.valueOf(companyId)}));
            properties.remove("saml.sp.default.idp.entity.id");
            configuration.update(properties);
        }
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.migrateSAMLProviderConfiguration();
        }
    }
}

