/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.saml.persistence.exception.DuplicateSamlIdpSpSessionException;
import com.liferay.saml.persistence.model.SamlIdpSpSession;
import com.liferay.saml.persistence.service.base.SamlIdpSpSessionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class SamlIdpSpSessionLocalServiceImpl
extends SamlIdpSpSessionLocalServiceBaseImpl {
    public SamlIdpSpSession addSamlIdpSpSession(long samlIdpSsoSessionId, String samlSpEntityId, String nameIdFormat, String nameIdValue, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUserById(serviceContext.getUserId());
        Date now = new Date();
        SamlIdpSpSession samlIdpSpSession = this.samlIdpSpSessionPersistence.fetchBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
        if (samlIdpSpSession != null) {
            throw new DuplicateSamlIdpSpSessionException(StringBundler.concat((Object[])new Object[]{"Duplicate SAML IDP SP ssession ", samlIdpSsoSessionId, " for ", samlSpEntityId}));
        }
        long samlIdpSpSessionId = this.counterLocalService.increment(SamlIdpSpSession.class.getName());
        samlIdpSpSession = this.samlIdpSpSessionPersistence.create(samlIdpSpSessionId);
        samlIdpSpSession.setCompanyId(serviceContext.getCompanyId());
        samlIdpSpSession.setUserId(user.getUserId());
        samlIdpSpSession.setUserName(user.getFullName());
        samlIdpSpSession.setCreateDate(now);
        samlIdpSpSession.setModifiedDate(now);
        samlIdpSpSession.setSamlIdpSsoSessionId(samlIdpSsoSessionId);
        samlIdpSpSession.setSamlSpEntityId(samlSpEntityId);
        samlIdpSpSession.setNameIdFormat(nameIdFormat);
        samlIdpSpSession.setNameIdValue(nameIdValue);
        return (SamlIdpSpSession)this.samlIdpSpSessionPersistence.update((BaseModel)samlIdpSpSession);
    }

    public SamlIdpSpSession getSamlIdpSpSession(long samlIdpSsoSessionId, String samlSpEntityId) throws PortalException {
        return this.samlIdpSpSessionPersistence.findBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
    }

    public List<SamlIdpSpSession> getSamlIdpSpSessions(long samlIdpSsoSessionId) {
        return this.samlIdpSpSessionPersistence.findBySamlIdpSsoSessionId(samlIdpSsoSessionId);
    }

    public SamlIdpSpSession updateModifiedDate(long samlIdpSsoSessionId, String samlSpEntityId) throws PortalException {
        SamlIdpSpSession samlIdpSpSession = this.samlIdpSpSessionPersistence.findBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
        samlIdpSpSession.setModifiedDate(new Date());
        return (SamlIdpSpSession)this.samlIdpSpSessionPersistence.update((BaseModel)samlIdpSpSession);
    }
}

