/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.metadata;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataGeneratorUtil;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfiguration;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import jakarta.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;

public class MetadataManagerUtil {
    private static final Log _log = LogFactoryUtil.getLog(MetadataManagerUtil.class);

    public static EntityDescriptor getEntityDescriptor(HttpServletRequest httpServletRequest, SamlProviderConfigurationHelper samlProviderConfigurationHelper, CredentialResolver credentialResolver, LocalEntityManager localEntityManager) throws SamlException {
        Credential encryptionCredential;
        block7: {
            encryptionCredential = null;
            try {
                encryptionCredential = MetadataManagerUtil._getEncryptionCredential(credentialResolver, localEntityManager);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)("Unable to get encryption credential: " + exception.getMessage()), (Throwable)exception);
            }
        }
        try {
            String portalURL = PortalUtil.getPortalURL((HttpServletRequest)httpServletRequest, (MetadataManagerUtil._isSSLRequired(samlProviderConfigurationHelper) || PortalUtil.isSecure((HttpServletRequest)httpServletRequest) ? 1 : 0) != 0);
            String localEntityId = localEntityManager.getLocalEntityId();
            if (samlProviderConfigurationHelper.isRoleIb()) {
                return MetadataGeneratorUtil.buildIbEntityDescriptor(portalURL, localEntityId, MetadataManagerUtil._isSignAuthnRequest(samlProviderConfigurationHelper), MetadataManagerUtil._isWantAuthnRequestSigned(samlProviderConfigurationHelper), MetadataManagerUtil._isSignMetadata(samlProviderConfigurationHelper), MetadataManagerUtil._getSigningCredential(credentialResolver, localEntityManager), encryptionCredential);
            }
            if (samlProviderConfigurationHelper.isRoleIdp()) {
                return MetadataGeneratorUtil.buildIdpEntityDescriptor(portalURL, localEntityId, MetadataManagerUtil._isWantAuthnRequestSigned(samlProviderConfigurationHelper), MetadataManagerUtil._isSignMetadata(samlProviderConfigurationHelper), MetadataManagerUtil._getSigningCredential(credentialResolver, localEntityManager), encryptionCredential);
            }
            if (samlProviderConfigurationHelper.isRoleSp()) {
                return MetadataGeneratorUtil.buildSpEntityDescriptor(portalURL, localEntityId, MetadataManagerUtil._isSignAuthnRequest(samlProviderConfigurationHelper), MetadataManagerUtil._isSignMetadata(samlProviderConfigurationHelper), MetadataManagerUtil._isWantAssertionsSigned(samlProviderConfigurationHelper), MetadataManagerUtil._getSigningCredential(credentialResolver, localEntityManager), encryptionCredential);
            }
            return null;
        }
        catch (Exception exception) {
            throw new SamlException((Throwable)exception);
        }
    }

    private static Credential _getEncryptionCredential(CredentialResolver credentialResolver, LocalEntityManager localEntityManager) throws SamlException {
        try {
            String entityId = localEntityManager.getLocalEntityId();
            if (Validator.isNull((String)entityId)) {
                return null;
            }
            return (Credential)credentialResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), new UsageCriterion(UsageType.ENCRYPTION)}));
        }
        catch (ResolverException resolverException) {
            throw new SamlException((Throwable)resolverException);
        }
    }

    private static SamlProviderConfiguration _getSamlProviderConfiguration(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        return samlProviderConfigurationHelper.getSamlProviderConfiguration();
    }

    private static Credential _getSigningCredential(CredentialResolver credentialResolver, LocalEntityManager localEntityManager) throws SamlException {
        try {
            String entityId = localEntityManager.getLocalEntityId();
            if (Validator.isNull((String)entityId)) {
                return null;
            }
            return (Credential)credentialResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), new UsageCriterion(UsageType.SIGNING)}));
        }
        catch (ResolverException resolverException) {
            throw new SamlException((Throwable)resolverException);
        }
    }

    private static boolean _isSignAuthnRequest(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        SamlProviderConfiguration samlProviderConfiguration = MetadataManagerUtil._getSamlProviderConfiguration(samlProviderConfigurationHelper);
        return samlProviderConfiguration.signAuthnRequest();
    }

    private static boolean _isSignMetadata(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        SamlProviderConfiguration samlProviderConfiguration = MetadataManagerUtil._getSamlProviderConfiguration(samlProviderConfigurationHelper);
        return samlProviderConfiguration.signMetadata();
    }

    private static boolean _isSSLRequired(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        SamlProviderConfiguration samlProviderConfiguration = MetadataManagerUtil._getSamlProviderConfiguration(samlProviderConfigurationHelper);
        return samlProviderConfiguration.sslRequired();
    }

    private static boolean _isWantAssertionsSigned(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        SamlProviderConfiguration samlProviderConfiguration = MetadataManagerUtil._getSamlProviderConfiguration(samlProviderConfigurationHelper);
        return samlProviderConfiguration.assertionSignatureRequired();
    }

    private static boolean _isWantAuthnRequestSigned(SamlProviderConfigurationHelper samlProviderConfigurationHelper) {
        SamlProviderConfiguration samlProviderConfiguration = MetadataManagerUtil._getSamlProviderConfiguration(samlProviderConfigurationHelper);
        return samlProviderConfiguration.authnRequestSignatureRequired();
    }
}

