/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.binding;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.saml.opensaml.integration.internal.binding.HttpPostBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpRedirectBinding;
import com.liferay.saml.opensaml.integration.internal.binding.HttpSoap11Binding;
import com.liferay.saml.opensaml.integration.internal.binding.SamlBinding;
import com.liferay.saml.opensaml.integration.internal.bootstrap.ParserPoolUtil;
import com.liferay.saml.opensaml.integration.internal.transport.HttpClientFactory;
import com.liferay.saml.opensaml.integration.internal.velocity.VelocityEngineFactory;
import com.liferay.saml.runtime.SamlException;
import java.util.Map;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SamlBindingProvider.class})
public class SamlBindingProvider {
    @Reference
    private HttpClientFactory _httpClientFactory;
    private final DCLSingleton<Map<String, SamlBinding>> _samlBingsDCLSingleton = new DCLSingleton();

    public SamlBinding getSamlBinding(String communicationProfileId) throws PortalException {
        Map samlBindings = (Map)this._samlBingsDCLSingleton.getSingleton(this::_createSamlBindings);
        SamlBinding samlBinding = (SamlBinding)samlBindings.get(communicationProfileId);
        if (samlBinding != null) {
            return samlBinding;
        }
        throw new SamlException("Unsupported SAML binding " + communicationProfileId);
    }

    private Map<String, SamlBinding> _createSamlBindings() {
        ParserPool parserPool = ParserPoolUtil.getParserPool();
        HttpPostBinding httpPostBinding = new HttpPostBinding(parserPool, VelocityEngineFactory.getVelocityEngine());
        HttpRedirectBinding httpRedirectBinding = new HttpRedirectBinding(parserPool);
        HttpSoap11Binding httpSoap11Binding = new HttpSoap11Binding(parserPool, this._httpClientFactory.getHttpClient());
        return HashMapBuilder.put((Object)httpPostBinding.getCommunicationProfileId(), (Object)httpPostBinding).put((Object)httpRedirectBinding.getCommunicationProfileId(), (Object)httpRedirectBinding).put((Object)httpSoap11Binding.getCommunicationProfileId(), (Object)httpSoap11Binding).build();
    }
}

