/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.saml.opensaml.integration.internal.bootstrap.ParserPoolUtil;
import com.liferay.saml.opensaml.integration.internal.transport.HttpClientFactory;
import com.liferay.saml.opensaml.integration.internal.util.SamlUtil;
import com.liferay.saml.util.MetadataUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MetadataUtil.class})
public class MetadataUtilImpl
implements MetadataUtil {
    @Reference
    protected HttpClientFactory httpClientFactory;

    public InputStream getMetadata(String url) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        HttpClient httpClient = this.httpClientFactory.getHttpClient();
        try {
            ByteArrayInputStream byteArrayInputStream;
            block14: {
                CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)httpClient.execute((HttpUriRequest)httpGet);
                try {
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    if (statusLine.getStatusCode() != 200) {
                        throw new Exception(StringBundler.concat((Object[])new Object[]{"Unable to get SAML metadata from ", url, ", invalid status code returned: ", statusLine.getStatusCode(), " ", statusLine.getReasonPhrase()}));
                    }
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    InputStream inputStream = httpEntity.getContent();
                    Header header = httpEntity.getContentEncoding();
                    if (header != null) {
                        String contentEncoding = header.getValue();
                        if (StringUtil.equalsIgnoreCase((String)contentEncoding, (String)"deflate")) {
                            inputStream = new InflaterInputStream(inputStream);
                        } else if (StringUtil.equalsIgnoreCase((String)contentEncoding, (String)"gzip")) {
                            inputStream = new GZIPInputStream(inputStream);
                        }
                    }
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream);
                    byte[] bytes = unsyncByteArrayOutputStream.toByteArray();
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                    if (closeableHttpResponse == null) break block14;
                }
                catch (Throwable throwable) {
                    if (closeableHttpResponse != null) {
                        try {
                            closeableHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                closeableHttpResponse.close();
            }
            return byteArrayInputStream;
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public String parseMetadataXml(InputStream inputStream1, String entityId) throws Exception {
        try (InputStream inputStream2 = inputStream1;){
            XMLObject xmlObject = XMLObjectSupport.unmarshallFromInputStream((ParserPool)ParserPoolUtil.getParserPool(), (InputStream)inputStream1);
            EntityDescriptor entityDescriptor = SamlUtil.getEntityDescriptorById(entityId, xmlObject);
            if (entityDescriptor == null) {
                String string = null;
                return string;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLObjectSupport.marshallToOutputStream((XMLObject)entityDescriptor, (OutputStream)byteArrayOutputStream);
            String string = byteArrayOutputStream.toString();
            return string;
        }
    }
}

