/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.credential;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.internal.credential.BaseKeyStoreManagerImpl;
import com.liferay.saml.opensaml.integration.internal.credential.FileWatcher;
import com.liferay.saml.runtime.credential.KeyStoreManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.saml.runtime.configuration.SamlConfiguration"}, property={"default=true"}, service={KeyStoreManager.class})
public class FileSystemKeyStoreManagerImpl
extends BaseKeyStoreManagerImpl {
    private static final Log _log = LogFactoryUtil.getLog(FileSystemKeyStoreManagerImpl.class);
    private KeyStore _keyStore;
    private volatile KeyStoreException _keyStoreException;
    private volatile FileWatcher _samlKeyStoreFileWatcher;

    public KeyStore getKeyStore() throws KeyStoreException {
        if (this._keyStoreException != null) {
            throw this._keyStoreException;
        }
        return this._keyStore;
    }

    public void saveKeyStore(KeyStore keyStore) throws Exception {
        File samlKeyStoreFile = new File(this.getSamlKeyStorePath());
        if (!(samlKeyStoreFile = samlKeyStoreFile.getAbsoluteFile()).exists()) {
            File parentDir;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Creating a new SAML keystore at " + String.valueOf(samlKeyStoreFile)));
            }
            if (!(parentDir = samlKeyStoreFile.getParentFile()).exists()) {
                parentDir.mkdirs();
            }
        }
        this._monitorFile(samlKeyStoreFile);
        String samlKeyStorePassword = this.getSamlKeyStorePassword();
        try (FileOutputStream fileOutputStream = new FileOutputStream(samlKeyStoreFile);){
            this._keyStore.store(fileOutputStream, samlKeyStorePassword.toCharArray());
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this.updateConfigurations(properties);
        String samlKeyStoreType = this.getSamlKeyStoreType();
        try {
            this._keyStore = KeyStore.getInstance(samlKeyStoreType);
        }
        catch (KeyStoreException keyStoreException) {
            String message = StringBundler.concat((String[])new String[]{"Unable instantiate keystore with type ", samlKeyStoreType, ": ", keyStoreException.getMessage()});
            this._keyStoreException = new KeyStoreException(message, keyStoreException);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)keyStoreException);
            } else {
                _log.error((Object)message);
            }
            return;
        }
        this._loadKeyStore();
    }

    @Deactivate
    protected void deactivate() {
        if (this._samlKeyStoreFileWatcher == null) {
            return;
        }
        try {
            this._samlKeyStoreFileWatcher.close();
        }
        catch (Exception exception) {
            String message = "Unable to close file watcher: " + exception.getMessage();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
        }
        finally {
            this._samlKeyStoreFileWatcher = null;
        }
    }

    private void _doLoadKeyStore() throws Exception {
        String samlKeyStorePassword = this.getSamlKeyStorePassword();
        try (InputStream inputStream = this._getInputStream();){
            this._keyStore.load(inputStream, samlKeyStorePassword.toCharArray());
        }
    }

    private InputStream _getInputStream() throws Exception {
        String samlKeyStorePath = this.getSamlKeyStorePath();
        if (samlKeyStorePath.startsWith("classpath:")) {
            Class<?> clazz = this.getClass();
            return clazz.getResourceAsStream(samlKeyStorePath.substring(10));
        }
        File samlKeyStoreFile = new File(samlKeyStorePath);
        if (!(samlKeyStoreFile = samlKeyStoreFile.getAbsoluteFile()).exists()) {
            if (Validator.isNotNull((String)this.samlConfiguration.keyStorePath()) && !"${liferay.home}/data/keystore.jks".equals(this.samlConfiguration.keyStorePath()) && _log.isWarnEnabled()) {
                _log.warn((Object)("No SAML keystore exists at " + String.valueOf(samlKeyStoreFile)));
            }
            return null;
        }
        this._monitorFile(samlKeyStoreFile);
        return new FileInputStream(samlKeyStoreFile);
    }

    private void _loadKeyStore() {
        try {
            this._keyStoreException = null;
            this._doLoadKeyStore();
        }
        catch (Exception exception) {
            String message = StringBundler.concat((String[])new String[]{"Unable to load SAML keystore ", this.getSamlKeyStorePath(), ": ", exception.getMessage()});
            this._keyStoreException = new KeyStoreException(message, exception);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)message, (Throwable)exception);
            }
            _log.error((Object)message);
        }
    }

    private void _monitorFile(File samlKeyStoreFile) throws Exception {
        if (this._samlKeyStoreFileWatcher != null) {
            return;
        }
        this._samlKeyStoreFileWatcher = new FileWatcher(ev -> this._loadKeyStore(), samlKeyStoreFile.toPath());
    }
}

