/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.field.expression.handler;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.saml.opensaml.integration.field.expression.handler.UserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.internal.field.expression.handler.DefaultUserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.processor.context.ProcessorContext;
import com.liferay.saml.opensaml.integration.processor.context.UserProcessorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"display.index:Integer=200", "prefix=membership", "processing.index:Integer=200"}, service={UserFieldExpressionHandler.class})
public class MembershipsUserFieldExpressionHandler
implements UserFieldExpressionHandler {
    private static final Log _log = LogFactoryUtil.getLog(MembershipsUserFieldExpressionHandler.class);
    private int _processingIndex;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    private final List<String> _validFieldExpressions = Collections.unmodifiableList(Arrays.asList("userGroups"));

    @Override
    public void bindProcessorContext(UserProcessorContext userProcessorContext) {
        ArrayList userGroupIds = new ArrayList();
        ProcessorContext.Bind userBind = userProcessorContext.bind(this._processingIndex, (currentUser, newUser, serviceContext) -> {
            this._userGroupLocalService.setUserUserGroups(newUser.getUserId(), ArrayUtil.toArray((Long[])userGroupIds.toArray(new Long[0])));
            return newUser;
        });
        userBind.mapStringArray("userGroups", (user, values) -> {
            if (values == null) {
                return;
            }
            for (String value : values) {
                UserGroup userGroup = this._userGroupLocalService.fetchUserGroup(user.getCompanyId(), value);
                if (userGroup != null) {
                    userGroupIds.add(userGroup.getUserGroupId());
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Ignored unknown user group: " + value));
            }
        });
    }

    @Override
    public User getLdapUser(long companyId, String userIdentifier, String userIdentifierExpression) throws Exception {
        return null;
    }

    @Override
    public String getSectionLabel(Locale locale) {
        return ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, DefaultUserFieldExpressionHandler.class), (String)"user-memberships");
    }

    @Override
    public User getUser(long companyId, String userIdentifier, String userIdentifierExpression) throws PortalException {
        return null;
    }

    @Override
    public List<String> getValidFieldExpressions() {
        return this._validFieldExpressions;
    }

    @Override
    public boolean isSupportedForUserMatching(String userIdentifier) {
        return false;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._processingIndex = GetterUtil.getInteger((Object)properties.get("processing.index"));
    }
}

