/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.profile;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.io.Serializable;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;

public class SamlSsoRequestContext
implements Serializable {
    public static final int STAGE_AUTHENTICATED = 1;
    public static final int STAGE_INITIAL = 0;
    private final String _authnRequestXml;
    private boolean _newSession;
    private final String _peerEntityId;
    private final String _relayState;
    private volatile SAMLMessageContext<AuthnRequest, Response, NameID> _samlMessageContext;
    private String _samlSsoSessionId;
    private int _stage;
    private long _userId;
    private final UserLocalService _userLocalService;

    public SamlSsoRequestContext(String peerEntityId, String relayState, SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext, UserLocalService userLocalService) {
        this(null, peerEntityId, relayState, samlMessageContext, userLocalService);
    }

    public SamlSsoRequestContext(String authnRequestXml, String peerEntityId, String relayState, SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext, UserLocalService userLocalService) {
        this._authnRequestXml = authnRequestXml;
        this._peerEntityId = peerEntityId;
        this._relayState = relayState;
        this._samlMessageContext = samlMessageContext;
        this._userLocalService = userLocalService;
    }

    public String getAutnRequestXml() {
        return this._authnRequestXml;
    }

    public String getPeerEntityId() {
        return this._peerEntityId;
    }

    public String getRelayState() {
        return this._relayState;
    }

    public SAMLMessageContext<AuthnRequest, Response, NameID> getSAMLMessageContext() {
        return this._samlMessageContext;
    }

    public String getSamlSsoSessionId() {
        return this._samlSsoSessionId;
    }

    public int getStage() {
        return this._stage;
    }

    public User getUser() {
        try {
            return this._userLocalService.fetchUserById(this._userId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getUserId() {
        return this._userId;
    }

    public boolean isNewSession() {
        return this._newSession;
    }

    public void setNewSession(boolean newSession) {
        this._newSession = newSession;
    }

    public void setSAMLMessageContext(SAMLMessageContext<AuthnRequest, Response, NameID> samlMessageContext) {
        this._samlMessageContext = samlMessageContext;
    }

    public void setSamlSsoSessionId(String samlSsoSessionId) {
        this._samlSsoSessionId = samlSsoSessionId;
    }

    public void setStage(int stage) {
        this._stage = stage;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }
}

