/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.push.notifications.model.PushNotificationsDevice;
import com.liferay.push.notifications.service.base.PushNotificationsDeviceServiceBaseImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=pushnotifications", "json.web.service.context.path=PushNotificationsDevice"}, service={AopService.class})
public class PushNotificationsDeviceServiceImpl
extends PushNotificationsDeviceServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PushNotificationsDeviceServiceImpl.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference(target="(resource.name=com.liferay.push.notifications)")
    private PortletResourcePermission _portletResourcePermission;

    @AccessControlled(guestAccessEnabled=true)
    public PushNotificationsDevice addPushNotificationsDevice(String token, String platform) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_DEVICES");
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.fetchByToken(token);
        if (pushNotificationsDevice == null) {
            pushNotificationsDevice = this.pushNotificationsDeviceLocalService.addPushNotificationsDevice(this.getGuestOrUserId(), platform, token);
        } else if (!platform.equals("sms")) {
            pushNotificationsDevice.setUserId(this.getGuestOrUserId());
            pushNotificationsDevice = this.pushNotificationsDeviceLocalService.updatePushNotificationsDevice(pushNotificationsDevice);
        }
        return pushNotificationsDevice;
    }

    public PushNotificationsDevice deletePushNotificationsDevice(long pushNotificationsDeviceId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_DEVICES");
        return this.pushNotificationsDeviceLocalService.deletePushNotificationsDevice(pushNotificationsDeviceId);
    }

    @AccessControlled(guestAccessEnabled=true)
    public PushNotificationsDevice deletePushNotificationsDevice(String token) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_DEVICES");
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.fetchByToken(token);
        if (pushNotificationsDevice == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("No device found with token " + token));
            }
        } else {
            long userId = this.getGuestOrUserId();
            if (pushNotificationsDevice.getUserId() == userId) {
                pushNotificationsDevice = this.pushNotificationsDeviceLocalService.deletePushNotificationsDevice(token);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Device found with token ", token, " does not belong to user ", userId}));
            }
        }
        return pushNotificationsDevice;
    }

    public void sendPushNotification(long[] toUserIds, String payload) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "SEND_PUSH_NOTIFICATION");
        JSONObject payloadJSONObject = this._jsonFactory.createJSONObject(payload);
        this.pushNotificationsDeviceLocalService.sendPushNotification(toUserIds, payloadJSONObject);
    }

    public void sendPushNotification(String platform, List<String> tokens, String payload) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "SEND_PUSH_NOTIFICATION");
        JSONObject payloadJSONObject = this._jsonFactory.createJSONObject(payload);
        this.pushNotificationsDeviceLocalService.sendPushNotification(platform, tokens, payloadJSONObject);
    }
}

