/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.service.impl;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.push.notifications.model.PushNotificationsDevice;
import com.liferay.push.notifications.sender.BaseResponse;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.service.base.PushNotificationsDeviceLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.push.notifications.model.PushNotificationsDevice"}, service={AopService.class})
public class PushNotificationsDeviceLocalServiceImpl
extends PushNotificationsDeviceLocalServiceBaseImpl {
    @Reference
    private MessageBus _messageBus;
    private ServiceTrackerMap<String, PushNotificationsSender> _serviceTrackerMap;
    @Reference
    private UserLocalService _userLocalService;

    public PushNotificationsDevice addPushNotificationsDevice(long userId, String platform, String token) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long pushNotificationsDeviceId = this.counterLocalService.increment();
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.create(pushNotificationsDeviceId);
        pushNotificationsDevice.setCompanyId(user.getCompanyId());
        pushNotificationsDevice.setUserId(user.getUserId());
        pushNotificationsDevice.setCreateDate(new Date());
        pushNotificationsDevice.setPlatform(platform);
        pushNotificationsDevice.setToken(token);
        return (PushNotificationsDevice)this.pushNotificationsDevicePersistence.update((BaseModel)pushNotificationsDevice);
    }

    public PushNotificationsDevice deletePushNotificationsDevice(String token) throws PortalException {
        PushNotificationsDevice pushNotificationsDevice = this.pushNotificationsDevicePersistence.findByToken(token);
        this.pushNotificationsDevicePersistence.remove((BaseModel)pushNotificationsDevice);
        return pushNotificationsDevice;
    }

    public List<PushNotificationsDevice> getPushNotificationsDevices(int start, int end, OrderByComparator<PushNotificationsDevice> orderByComparator) {
        return this.pushNotificationsDevicePersistence.findAll(start, end, orderByComparator);
    }

    public void sendPushNotification(long[] toUserIds, JSONObject payloadJSONObject) throws PortalException {
        for (String platform : this._serviceTrackerMap.keySet()) {
            ArrayList<String> tokens = new ArrayList<String>();
            List pushNotificationsDevices = this.pushNotificationsDevicePersistence.findByU_P(toUserIds, platform, -1, -1);
            for (PushNotificationsDevice pushNotificationsDevice : pushNotificationsDevices) {
                tokens.add(pushNotificationsDevice.getToken());
            }
            if (tokens.isEmpty()) continue;
            this.sendPushNotification(platform, tokens, payloadJSONObject);
        }
    }

    public void sendPushNotification(String platform, List<String> tokens, JSONObject payloadJSONObject) throws PortalException {
        PushNotificationsSender pushNotificationsSender = (PushNotificationsSender)this._serviceTrackerMap.getService((Object)platform);
        if (pushNotificationsSender == null) {
            return;
        }
        Throwable exception1 = null;
        try {
            pushNotificationsSender.send(tokens, payloadJSONObject);
        }
        catch (PortalException portalException) {
            exception1 = portalException;
            throw portalException;
        }
        catch (Exception exception2) {
            exception1 = exception2;
            throw new PortalException((Throwable)exception2);
        }
        finally {
            if (exception1 != null) {
                Message message = new Message();
                message.setPayload((Object)new BaseResponse(platform, (Exception)exception1));
                this._messageBus.sendMessage("liferay/push_notification_response", message);
            }
        }
    }

    public void updateToken(String oldToken, String newToken) throws PortalException {
        PushNotificationsDevice oldPushNotificationsDevice = this.deletePushNotificationsDevice(oldToken);
        PushNotificationsDevice newPushNotificationsDevice = this.pushNotificationsDevicePersistence.fetchByToken(newToken);
        if (newPushNotificationsDevice == null) {
            this.addPushNotificationsDevice(oldPushNotificationsDevice.getUserId(), oldPushNotificationsDevice.getPlatform(), newToken);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PushNotificationsSender.class, (String)"platform");
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._serviceTrackerMap.close();
    }
}

