/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.internal.messaging;

import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.push.notifications.internal.messaging.PushNotificationsMessageListener;
import com.liferay.push.notifications.internal.messaging.PushNotificationsResponseMessageListener;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalService;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={PushNotificationMessagingConfigurator.class})
public class PushNotificationMessagingConfigurator {
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private PushNotificationsDeviceLocalService _pushNotificationsDeviceLocalService;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._registerMessaging(bundleContext, "liferay/push_notification", (MessageListener)new PushNotificationsMessageListener(this._pushNotificationsDeviceLocalService));
        this._registerMessaging(bundleContext, "liferay/push_notification_response", (MessageListener)new PushNotificationsResponseMessageListener(this._jsonFactory));
    }

    @Deactivate
    protected void deactivate() {
        if (!this._serviceRegistrations.isEmpty()) {
            for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
                serviceRegistration.unregister();
            }
            this._serviceRegistrations.clear();
        }
    }

    private void _registerMessaging(BundleContext bundleContext, String destinationName, MessageListener messageListener) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("serial", destinationName));
        Dictionary dictionary = MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName());
        this._serviceRegistrations.add(bundleContext.registerService(Destination.class, (Object)destination, dictionary));
        this._serviceRegistrations.add(bundleContext.registerService(MessageListener.class, (Object)messageListener, dictionary));
    }
}

