/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.internal.messaging;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalService;

public class PushNotificationsMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(PushNotificationsMessageListener.class);
    private final PushNotificationsDeviceLocalService _pushNotificationsDeviceLocalService;

    public PushNotificationsMessageListener(PushNotificationsDeviceLocalService pushNotificationsDeviceLocalService) {
        this._pushNotificationsDeviceLocalService = pushNotificationsDeviceLocalService;
    }

    protected void doReceive(Message message) throws Exception {
        JSONObject payloadJSONObject = (JSONObject)message.getPayload();
        JSONArray toUserIdsJSONArray = payloadJSONObject.getJSONArray("toUserIds");
        long[] toUserIds = null;
        if (toUserIdsJSONArray != null) {
            toUserIds = new long[toUserIdsJSONArray.length()];
            for (int i = 0; i < toUserIdsJSONArray.length(); ++i) {
                toUserIds[i] = toUserIdsJSONArray.getLong(i);
            }
            payloadJSONObject.remove("toUserIds");
        } else {
            long userId = payloadJSONObject.getLong("userId");
            toUserIds = new long[]{userId};
        }
        try {
            this._pushNotificationsDeviceLocalService.sendPushNotification(toUserIds, payloadJSONObject);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to send notification", (Throwable)exception);
        }
    }
}

